/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.wrap;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.weed.wrap.ClassWrap;
import org.noear.weed.wrap.Property;

public class PropertyWrap
implements Serializable {
    private static Map<String, Class<?>> _clzCache = new ConcurrentHashMap();
    public final Property property;
    public final ClassWrap clzWrap;
    public final String name;
    private String _alias;
    private static Map<Property, PropertyWrap> _popCache = new ConcurrentHashMap<Property, PropertyWrap>();

    private static Class<?> getClz(String implClz) {
        Class<?> clz = _clzCache.get(implClz);
        if (clz == null) {
            try {
                clz = Class.forName(implClz.replace("/", "."));
                Class<?> l = _clzCache.putIfAbsent(implClz, clz);
                if (l != null) {
                    clz = l;
                }
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        return clz;
    }

    public PropertyWrap alias(String alias) {
        this._alias = alias;
        return this;
    }

    public PropertyWrap(PropertyWrap pw) {
        this.property = pw.property;
        this.clzWrap = pw.clzWrap;
        this.name = pw.name;
    }

    public PropertyWrap(Property p, String implClz, String name) {
        this.property = p;
        this.clzWrap = ClassWrap.get(PropertyWrap.getClz(implClz));
        this.name = this.clzWrap.getFieldWrap((String)name).name;
    }

    public String getColumnName(List<ClassWrap> cl) {
        if (cl == null) {
            return this.name;
        }
        int idx = cl.indexOf(this.clzWrap);
        if (idx < 0) {
            return this.name;
        }
        return "t" + idx + "." + this.name;
    }

    public String getSelectName(List<ClassWrap> cl) {
        if (this._alias == null) {
            return this.getColumnName(cl);
        }
        return this.getColumnName(cl) + " " + this._alias;
    }

    public static <C> PropertyWrap get(Property<C, ?> p) {
        PropertyWrap l;
        PropertyWrap tmp = _popCache.get(p);
        if (tmp == null && (l = _popCache.putIfAbsent(p, tmp = PropertyWrap.wrap(p))) != null) {
            tmp = l;
        }
        return tmp;
    }

    private static <C> PropertyWrap wrap(Property<C, ?> p) {
        try {
            Method fun = p.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            fun.setAccessible(Boolean.TRUE);
            SerializedLambda slambda = (SerializedLambda)fun.invoke(p, new Object[0]);
            String method = slambda.getImplMethodName();
            String attr = null;
            attr = method.startsWith("get") ? method.substring(3) : method.substring(2);
            return new PropertyWrap(p, slambda.getImplClass(), attr);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

