/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.weed.DataItem;
import org.noear.weed.utils.IOUtils;
import org.noear.weed.xml.IXmlSqlBuilder;
import org.noear.weed.xml.XmlSqlVar;
import org.w3c.dom.Node;

public class XmlSqlBlock {
    private static final String _lock = "";
    public String _namespace;
    public String _classname;
    public StringBuilder _classcode;
    public StringBuilder _classcode2;
    public List<String> _import = new ArrayList<String>();
    public String _id;
    public String _param;
    public String _declare;
    public String _return;
    public String _return_item;
    public String _caching;
    public String _cacheClear;
    public String _cacheTag;
    public String _usingCache;
    public Map<String, XmlSqlVar> tagMap = new LinkedHashMap<String, XmlSqlVar>();
    protected Map<String, Node> __nodeMap;
    protected StringBuilder _texts = new StringBuilder();
    public String _action;
    private Map<String, XmlSqlVar> varMap = new LinkedHashMap<String, XmlSqlVar>();
    public int varNum = 0;
    public IXmlSqlBuilder builder;
    static final String java_types = ",char,boolean,short,int,long,float,double,Character,Boolean,Short,Integer,Long,Float,Double,Date,LocalDateTime,LocalTime,LocalDate,Object,";
    static final String weed_types = ",Map,MapList,DateItem,DateList,";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StringBuilder getClasscode(boolean lineNo) {
        if (!lineNo) return this._classcode;
        if (this._classcode2 != null) return this._classcode2;
        String string = _lock;
        synchronized (_lock) {
            if (this._classcode2 != null) return this._classcode2;
            this._classcode2 = new StringBuilder();
            String[] ss = this._classcode.toString().split("\n");
            int len = ss.length;
            for (int i = 0; i < len; ++i) {
                this._classcode2.append(i + 1).append(". ").append(ss[i]).append("\n");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this._classcode2;
        }
    }

    public boolean isSelect() {
        return "SELECT".equals(this._action);
    }

    public boolean isInsert() {
        return "INSERT".equals(this._action);
    }

    public Collection<XmlSqlVar> varList() {
        return Collections.unmodifiableCollection(this.varMap.values());
    }

    public void varPut(XmlSqlVar dv) {
        if (dv.type == null || dv.type.length() == 0) {
            this.varMap.putIfAbsent(dv.name, dv);
        } else {
            this.varMap.put(dv.name, dv);
        }
    }

    public String formatRemoveTags(XmlSqlBlock block, Map map) {
        String txt2 = block._cacheClear;
        for (XmlSqlVar dv : block.tagMap.values()) {
            if (dv.label != 0) continue;
            Object val = map.get(dv.name);
            if (val == null) {
                throw new RuntimeException("Parameter does not exist:@" + dv.name);
            }
            txt2 = txt2.replace(dv.mark, val.toString());
        }
        return txt2;
    }

    public String formatAppendTags(XmlSqlBlock block, Map map, Object rst) {
        String txt2 = block._cacheTag;
        for (XmlSqlVar dv : block.tagMap.values()) {
            if (dv.label != 1) continue;
            Object val = map.get(dv.name);
            if (val == null && rst != null && rst instanceof DataItem) {
                val = ((DataItem)rst).get(dv.name);
            }
            if (val == null) {
                throw new RuntimeException("Parameter does not exist:@" + dv.name);
            }
            txt2 = txt2.replace(dv.mark, val.toString());
        }
        return txt2;
    }

    public String newType(String type) {
        if (type == null) {
            return null;
        }
        if (this._import == null || this._import.size() == 0) {
            return type;
        }
        if (type.indexOf(".") >= 0) {
            return type;
        }
        if (type.indexOf(">") >= 0) {
            return type;
        }
        if (java_types.indexOf("," + type + ",") >= 0) {
            return type;
        }
        if (weed_types.indexOf("," + type + ",") >= 0) {
            return type;
        }
        for (String pg : this._import) {
            if (pg.endsWith("*")) {
                String tm = pg.substring(0, pg.length() - 1) + type;
                if (IOUtils.loadClass(tm) == null) continue;
                return tm;
            }
            if (!pg.endsWith(type)) continue;
            return pg;
        }
        return type;
    }
}

