/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.security.Provider;
import org.openeuler.AbstractEntries;
import org.openeuler.BGMJCEConfig;

class BGMLegacyJCEEntries
extends AbstractEntries {
    public BGMLegacyJCEEntries(Provider provider) {
        super(provider);
    }

    @Override
    protected void putServices(Provider provider) {
        if (BGMJCEConfig.enableSM2()) {
            this.putSM2(provider);
        }
        if (BGMJCEConfig.enableEC()) {
            this.putEC(provider);
        }
        if (BGMJCEConfig.enableSM3()) {
            this.putSM3(provider);
        }
        if (BGMJCEConfig.enableSM3withSM2()) {
            this.putSM3withSM2(provider);
        }
        if (BGMJCEConfig.enableSM4()) {
            this.putSM4(provider);
        }
        if (BGMJCEConfig.enablePBES2()) {
            this.putPBES2(provider);
        }
    }

    private void putSM2(Provider provider) {
        this.add(provider, "Cipher", "SM2", "org.openeuler.legacy.SM2Cipher");
        this.add(provider, "KeyPairGenerator", "SM2", "org.openeuler.legacy.SM2KeyPairGenerator");
        this.add(provider, "KeyAgreement", "SM2", "org.openeuler.legacy.SM2KeyAgreement");
        this.add(provider, "KeyFactory", "SM2", "org.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi$EC", BGMLegacyJCEEntries.createAliasesWithOid("1.2.156.10197.1.301"));
        this.add(provider, "AlgorithmParameters", "SM2", "org.bouncycastle.jcajce.provider.asymmetric.ec.AlgorithmParametersSpi", BGMLegacyJCEEntries.createAliasesWithOid("1.2.156.10197.1.301"));
    }

    private void putEC(Provider provider) {
        this.add(provider, "KeyPairGenerator", "EC", "org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$EC");
        this.add(provider, "KeyFactory", "EC", "org.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi$EC", BGMLegacyJCEEntries.createAliasesWithOid("1.2.840.10045.2.1"));
        this.add(provider, "AlgorithmParameters", "EC", "org.bouncycastle.jcajce.provider.asymmetric.ec.AlgorithmParametersSpi", BGMLegacyJCEEntries.createAliasesWithOid("1.2.840.10045.2.1"));
    }

    private void putSM3(Provider provider) {
        this.add(provider, "MessageDigest", "SM3", "org.bouncycastle.jcajce.provider.digest.SM3$Digest", BGMLegacyJCEEntries.createAliasesWithOid("1.2.156.10197.1.401"));
        this.add(provider, "Mac", "HmacSM3", "org.bouncycastle.jcajce.provider.digest.SM3$HashMac");
        this.add(provider, "KeyGenerator", "HmacSM3", "org.bouncycastle.jcajce.provider.digest.SM3$KeyGenerator");
    }

    private void putSM3withSM2(Provider provider) {
        this.add(provider, "Signature", "SM3withSM2", "org.bouncycastle.jcajce.provider.asymmetric.ec.GMSignatureSpi$sm3WithSM2", BGMLegacyJCEEntries.createAliasesWithOid("1.2.156.10197.1.501"));
    }

    private void putSM4(Provider provider) {
        this.add(provider, "Cipher", "SM4", "org.bouncycastle.jcajce.provider.symmetric.SM4$ECB");
        this.add(provider, "AlgorithmParameters", "SM4", "org.bouncycastle.jcajce.provider.symmetric.SM4$AlgParams");
        this.add(provider, "AlgorithmParameterGenerator", "SM4", "org.bouncycastle.jcajce.provider.symmetric.SM4$AlgParamGen");
        this.add(provider, "KeyGenerator", "SM4", "org.bouncycastle.jcajce.provider.symmetric.SM4$KeyGen");
    }

    private void putPBES2(Provider provider) {
        this.add(provider, "AlgorithmParameters", "GMPBES2", "org.openeuler.com.sun.crypto.provider.PBES2Parameters$General", BGMLegacyJCEEntries.createAliasesWithOid("1.2.156.10197.6.1.4.1.5.2"));
        this.add(provider, "AlgorithmParameters", "PBEWithHmacSM3AndSM4_128/ECB/PKCS5Padding", "org.openeuler.com.sun.crypto.provider.PBES2Parameters$HmacSM3AndSM4_128_ECB_PKCS5Padding");
        this.add(provider, "AlgorithmParameters", "PBEWithHmacSM3AndSM4_128/CBC/PKCS5Padding", "org.openeuler.com.sun.crypto.provider.PBES2Parameters$HmacSM3AndSM4_128_CBC_PKCS5Padding", BGMLegacyJCEEntries.createAliases("PBEWithHmacSM3AndSM4_CBC"));
        this.add(provider, "Cipher", "PBEWithHmacSM3AndSM4_128/ECB/PKCS5Padding", "org.openeuler.com.sun.crypto.provider.PBES2Core$HmacSM3AndSM4_128_ECB_PKCS5Padding");
        this.add(provider, "Cipher", "PBEWithHmacSM3AndSM4_128/CBC/PKCS5Padding", "org.openeuler.com.sun.crypto.provider.PBES2Core$HmacSM3AndSM4_128_CBC_PKCS5Padding", BGMLegacyJCEEntries.createAliases("PBEWithHmacSM3AndSM4_CBC"));
        this.add(provider, "SecretKeyFactory", "PBKDF2WithHmacSM3", "org.openeuler.com.sun.crypto.provider.PBKDF2Core$HmacSM3");
        this.add(provider, "SecretKeyFactory", "PBEWithHmacSM3AndSM4_128/ECB/PKCS5Padding", "org.openeuler.com.sun.crypto.provider.PBEKeyFactory$PBEWithHmacSM3AndSM4_128_ECB_PKCS5Padding");
        this.add(provider, "SecretKeyFactory", "PBEWithHmacSM3AndSM4_128/CBC/PKCS5Padding", "org.openeuler.com.sun.crypto.provider.PBEKeyFactory$PBEWithHmacSM3AndSM4_128_CBC_PKCS5Padding", BGMLegacyJCEEntries.createAliases("PBEWithHmacSM3AndSM4_CBC"));
        this.add(provider, "Mac", "HmacPBESM3", "org.openeuler.com.sun.crypto.provider.HmacPKCS12PBECore$HmacPKCS12PBESM3");
    }
}

