/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import org.openeuler.sun.security.ec.BGECPrivateKey;
import org.openeuler.sun.security.ec.BGECPublicKey;
import org.openeuler.util.GMUtil;
import sun.security.util.ECKeySizeParameterSpec;

public class ECCKeyPairGenerator
extends KeyPairGeneratorSpi {
    private KeyPairGenerator keyPairGenerator;
    private boolean isInitialized = false;
    private boolean isGMCurve = false;

    @Override
    public void initialize(int keysize, SecureRandom random) {
        try {
            this.initialize(new ECKeySizeParameterSpec(keysize), random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.isGMCurve = GMUtil.isSM2Curve(params);
        String algorithm = "EC";
        String provider = "SunEC";
        if (this.isGMCurve) {
            algorithm = "SM2";
            provider = null;
        }
        try {
            this.keyPairGenerator = provider == null ? KeyPairGenerator.getInstance(algorithm) : KeyPairGenerator.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new InvalidAlgorithmParameterException(e);
        }
        this.keyPairGenerator.initialize(params, random);
        this.isInitialized = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.isInitialized) {
            this.initialize(256, new SecureRandom());
        }
        if (this.isGMCurve) {
            return this.keyPairGenerator.generateKeyPair();
        }
        KeyPair keyPair = this.keyPairGenerator.generateKeyPair();
        ECPrivateKey privateKey = (ECPrivateKey)keyPair.getPrivate();
        ECPublicKey publicKey = (ECPublicKey)keyPair.getPublic();
        ECParameterSpec ecParams = publicKey.getParams();
        try {
            BGECPrivateKey bgPrivateKey = new BGECPrivateKey(privateKey.getS(), ecParams);
            BGECPublicKey bgPublicKey = new BGECPublicKey(publicKey.getW(), ecParams);
            return new KeyPair(bgPublicKey, bgPrivateKey);
        }
        catch (InvalidKeyException e) {
            throw new ProviderException(e);
        }
    }
}

