/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sm4;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.openeuler.sm4.SM4BaseCipher;
import org.openeuler.sm4.mode.CBC;
import org.openeuler.sm4.mode.CCM;
import org.openeuler.sm4.mode.CFB;
import org.openeuler.sm4.mode.CTR;
import org.openeuler.sm4.mode.CTS;
import org.openeuler.sm4.mode.ECB;
import org.openeuler.sm4.mode.GCM;
import org.openeuler.sm4.mode.OCB;
import org.openeuler.sm4.mode.OFB;

public class SM4Cipher
extends CipherSpi {
    private SM4BaseCipher cipher;
    private final int BLOCK_SIZE = 16;

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        String upperMode = mode.toUpperCase();
        if ("ECB".equals(upperMode)) {
            this.cipher = new ECB();
        } else if ("CBC".equals(upperMode)) {
            this.cipher = new CBC();
        } else if ("CTR".equals(upperMode)) {
            this.cipher = new CTR();
        } else if ("CFB".equals(upperMode)) {
            this.cipher = new CFB();
        } else if ("OFB".equals(upperMode)) {
            this.cipher = new OFB();
        } else if ("OCB".equals(upperMode)) {
            this.cipher = new OCB();
        } else if ("CTS".equals(upperMode)) {
            this.cipher = new CTS();
        } else if ("GCM".equals(upperMode)) {
            this.cipher = new GCM();
        } else if ("CCM".equals(upperMode)) {
            this.cipher = new CCM();
        } else {
            throw new NoSuchAlgorithmException("unknow mode: " + mode);
        }
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if ("PKCS5Padding".toUpperCase().equals(padding.toUpperCase())) {
            this.cipher.engineSetPadding(padding.toUpperCase());
        } else if ("PKCS7Padding".toUpperCase().equals(padding.toUpperCase())) {
            this.cipher.engineSetPadding(padding.toUpperCase());
        } else if ("nopadding".toUpperCase().equals(padding.toUpperCase())) {
            this.cipher.engineSetPadding(padding.toUpperCase());
        } else {
            throw new NoSuchPaddingException("unknow padding: " + padding);
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.cipher.engineGetOutputSize(inputLen);
    }

    @Override
    protected byte[] engineGetIV() {
        return this.cipher.engineGetIV();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return this.cipher.engineGetParameters();
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.cipher.engineInit(opmode, key, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipher.engineInit(opmode, key, params, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipher.engineInit(opmode, key, params, random);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        return this.cipher.engineUpdate(input, inputOffset, inputLen);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.cipher.engineUpdate(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (input == null) {
            input = new byte[]{};
        }
        return this.cipher.engineDoFinal(input, inputOffset, inputLen);
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (input == null) {
            input = new byte[]{};
        }
        return this.cipher.engineDoFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected void engineUpdateAAD(byte[] src, int offset, int len) {
        this.cipher.engineUpdateAAD(src, offset, len);
    }
}

