/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.util;

import java.math.BigInteger;
import org.openeuler.util.Util;

public class Nat256 {
    private static final long M = 0xFFFFFFFFL;

    public static int add(int[] x, int[] y, int[] z) {
        long c = 0L;
        for (int i = 0; i < 8; ++i) {
            z[i] = (int)(c += ((long)x[i] & 0xFFFFFFFFL) + ((long)y[i] & 0xFFFFFFFFL));
            c >>>= 32;
        }
        return (int)c;
    }

    public static int addBothTo(int[] x, int[] y, int[] z) {
        long c = 0L;
        for (int i = 0; i < 8; ++i) {
            z[i] = (int)(c += ((long)x[i] & 0xFFFFFFFFL) + ((long)y[i] & 0xFFFFFFFFL) + ((long)z[i] & 0xFFFFFFFFL));
            c >>>= 32;
        }
        return (int)c;
    }

    public static int[] create() {
        return new int[8];
    }

    public static int[] createExt() {
        return new int[16];
    }

    public static int[] fromBigInteger(BigInteger x) {
        if (x.signum() < 0 || x.bitLength() > 256) {
            throw new IllegalArgumentException();
        }
        int[] z = Nat256.create();
        for (int i = 0; i < 8; ++i) {
            z[i] = x.intValue();
            x = x.shiftRight(32);
        }
        return z;
    }

    public static boolean gte(int[] x, int[] y) {
        for (int i = 7; i >= 0; --i) {
            int x_i = x[i] ^ Integer.MIN_VALUE;
            int y_i = y[i] ^ Integer.MIN_VALUE;
            if (x_i < y_i) {
                return false;
            }
            if (x_i <= y_i) continue;
            return true;
        }
        return true;
    }

    public static boolean isOne(int[] x) {
        if (x[0] != 1) {
            return false;
        }
        for (int i = 1; i < 8; ++i) {
            if (x[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int[] x) {
        for (int i = 0; i < 8; ++i) {
            if (x[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static void mul(int[] x, int[] y, int[] zz) {
        long y_0 = (long)y[0] & 0xFFFFFFFFL;
        long y_1 = (long)y[1] & 0xFFFFFFFFL;
        long y_2 = (long)y[2] & 0xFFFFFFFFL;
        long y_3 = (long)y[3] & 0xFFFFFFFFL;
        long y_4 = (long)y[4] & 0xFFFFFFFFL;
        long y_5 = (long)y[5] & 0xFFFFFFFFL;
        long y_6 = (long)y[6] & 0xFFFFFFFFL;
        long y_7 = (long)y[7] & 0xFFFFFFFFL;
        long c = 0L;
        long x_0 = (long)x[0] & 0xFFFFFFFFL;
        zz[0] = (int)(c += x_0 * y_0);
        c >>>= 32;
        zz[1] = (int)(c += x_0 * y_1);
        c >>>= 32;
        zz[2] = (int)(c += x_0 * y_2);
        c >>>= 32;
        zz[3] = (int)(c += x_0 * y_3);
        c >>>= 32;
        zz[4] = (int)(c += x_0 * y_4);
        c >>>= 32;
        zz[5] = (int)(c += x_0 * y_5);
        c >>>= 32;
        zz[6] = (int)(c += x_0 * y_6);
        c >>>= 32;
        zz[7] = (int)(c += x_0 * y_7);
        zz[8] = (int)(c >>>= 32);
        for (int i = 1; i < 8; ++i) {
            long c2 = 0L;
            long x_i = (long)x[i] & 0xFFFFFFFFL;
            zz[i + 0] = (int)(c2 += x_i * y_0 + ((long)zz[i + 0] & 0xFFFFFFFFL));
            c2 >>>= 32;
            zz[i + 1] = (int)(c2 += x_i * y_1 + ((long)zz[i + 1] & 0xFFFFFFFFL));
            c2 >>>= 32;
            zz[i + 2] = (int)(c2 += x_i * y_2 + ((long)zz[i + 2] & 0xFFFFFFFFL));
            c2 >>>= 32;
            zz[i + 3] = (int)(c2 += x_i * y_3 + ((long)zz[i + 3] & 0xFFFFFFFFL));
            c2 >>>= 32;
            zz[i + 4] = (int)(c2 += x_i * y_4 + ((long)zz[i + 4] & 0xFFFFFFFFL));
            c2 >>>= 32;
            zz[i + 5] = (int)(c2 += x_i * y_5 + ((long)zz[i + 5] & 0xFFFFFFFFL));
            c2 >>>= 32;
            zz[i + 6] = (int)(c2 += x_i * y_6 + ((long)zz[i + 6] & 0xFFFFFFFFL));
            c2 >>>= 32;
            zz[i + 7] = (int)(c2 += x_i * y_7 + ((long)zz[i + 7] & 0xFFFFFFFFL));
            zz[i + 8] = (int)(c2 >>>= 32);
        }
    }

    public static int mulAddTo(int[] x, int[] y, int[] zz) {
        long y_0 = (long)y[0] & 0xFFFFFFFFL;
        long y_1 = (long)y[1] & 0xFFFFFFFFL;
        long y_2 = (long)y[2] & 0xFFFFFFFFL;
        long y_3 = (long)y[3] & 0xFFFFFFFFL;
        long y_4 = (long)y[4] & 0xFFFFFFFFL;
        long y_5 = (long)y[5] & 0xFFFFFFFFL;
        long y_6 = (long)y[6] & 0xFFFFFFFFL;
        long y_7 = (long)y[7] & 0xFFFFFFFFL;
        long zc = 0L;
        for (int i = 0; i < 8; ++i) {
            long c = 0L;
            long x_i = (long)x[i] & 0xFFFFFFFFL;
            zz[i + 0] = (int)(c += x_i * y_0 + ((long)zz[i + 0] & 0xFFFFFFFFL));
            c >>>= 32;
            zz[i + 1] = (int)(c += x_i * y_1 + ((long)zz[i + 1] & 0xFFFFFFFFL));
            c >>>= 32;
            zz[i + 2] = (int)(c += x_i * y_2 + ((long)zz[i + 2] & 0xFFFFFFFFL));
            c >>>= 32;
            zz[i + 3] = (int)(c += x_i * y_3 + ((long)zz[i + 3] & 0xFFFFFFFFL));
            c >>>= 32;
            zz[i + 4] = (int)(c += x_i * y_4 + ((long)zz[i + 4] & 0xFFFFFFFFL));
            c >>>= 32;
            zz[i + 5] = (int)(c += x_i * y_5 + ((long)zz[i + 5] & 0xFFFFFFFFL));
            c >>>= 32;
            zz[i + 6] = (int)(c += x_i * y_6 + ((long)zz[i + 6] & 0xFFFFFFFFL));
            c >>>= 32;
            zz[i + 7] = (int)(c += x_i * y_7 + ((long)zz[i + 7] & 0xFFFFFFFFL));
            zz[i + 8] = (int)(zc += (c >>>= 32) + ((long)zz[i + 8] & 0xFFFFFFFFL));
            zc >>>= 32;
        }
        return (int)zc;
    }

    public static void square(int[] x, int[] zz) {
        long x_0 = (long)x[0] & 0xFFFFFFFFL;
        int c = 0;
        int i = 7;
        int j = 16;
        do {
            long xVal = (long)x[i--] & 0xFFFFFFFFL;
            long p = xVal * xVal;
            zz[--j] = c << 31 | (int)(p >>> 33);
            zz[--j] = (int)(p >>> 1);
            c = (int)p;
        } while (i > 0);
        long p = x_0 * x_0;
        long zz_1 = (long)(c << 31) & 0xFFFFFFFFL | p >>> 33;
        zz[0] = (int)p;
        c = (int)(p >>> 32) & 1;
        long x_1 = (long)x[1] & 0xFFFFFFFFL;
        long zz_2 = (long)zz[2] & 0xFFFFFFFFL;
        int w = (int)(zz_1 += x_1 * x_0);
        zz[1] = w << 1 | c;
        c = w >>> 31;
        zz_2 += zz_1 >>> 32;
        long x_2 = (long)x[2] & 0xFFFFFFFFL;
        long zz_3 = (long)zz[3] & 0xFFFFFFFFL;
        long zz_4 = (long)zz[4] & 0xFFFFFFFFL;
        w = (int)(zz_2 += x_2 * x_0);
        zz[2] = w << 1 | c;
        c = w >>> 31;
        zz_3 &= 0xFFFFFFFFL;
        long x_3 = (long)x[3] & 0xFFFFFFFFL;
        long zz_5 = ((long)zz[5] & 0xFFFFFFFFL) + ((zz_4 += (zz_3 += (zz_2 >>> 32) + x_2 * x_1) >>> 32) >>> 32);
        zz_4 &= 0xFFFFFFFFL;
        long zz_6 = ((long)zz[6] & 0xFFFFFFFFL) + (zz_5 >>> 32);
        zz_5 &= 0xFFFFFFFFL;
        w = (int)(zz_3 += x_3 * x_0);
        zz[3] = w << 1 | c;
        c = w >>> 31;
        zz_4 &= 0xFFFFFFFFL;
        zz_5 &= 0xFFFFFFFFL;
        long x_4 = (long)x[4] & 0xFFFFFFFFL;
        long zz_7 = ((long)zz[7] & 0xFFFFFFFFL) + ((zz_6 += (zz_5 += ((zz_4 += (zz_3 >>> 32) + x_3 * x_1) >>> 32) + x_3 * x_2) >>> 32) >>> 32);
        zz_6 &= 0xFFFFFFFFL;
        long zz_8 = ((long)zz[8] & 0xFFFFFFFFL) + (zz_7 >>> 32);
        zz_7 &= 0xFFFFFFFFL;
        w = (int)(zz_4 += x_4 * x_0);
        zz[4] = w << 1 | c;
        c = w >>> 31;
        zz_5 &= 0xFFFFFFFFL;
        zz_6 &= 0xFFFFFFFFL;
        zz_7 &= 0xFFFFFFFFL;
        long x_5 = (long)x[5] & 0xFFFFFFFFL;
        long zz_9 = ((long)zz[9] & 0xFFFFFFFFL) + ((zz_8 += (zz_7 += ((zz_6 += ((zz_5 += (zz_4 >>> 32) + x_4 * x_1) >>> 32) + x_4 * x_2) >>> 32) + x_4 * x_3) >>> 32) >>> 32);
        zz_8 &= 0xFFFFFFFFL;
        long zz_10 = ((long)zz[10] & 0xFFFFFFFFL) + (zz_9 >>> 32);
        zz_9 &= 0xFFFFFFFFL;
        w = (int)(zz_5 += x_5 * x_0);
        zz[5] = w << 1 | c;
        c = w >>> 31;
        zz_6 &= 0xFFFFFFFFL;
        zz_7 &= 0xFFFFFFFFL;
        zz_8 &= 0xFFFFFFFFL;
        zz_9 &= 0xFFFFFFFFL;
        long x_6 = (long)x[6] & 0xFFFFFFFFL;
        long zz_11 = ((long)zz[11] & 0xFFFFFFFFL) + ((zz_10 += (zz_9 += ((zz_8 += ((zz_7 += ((zz_6 += (zz_5 >>> 32) + x_5 * x_1) >>> 32) + x_5 * x_2) >>> 32) + x_5 * x_3) >>> 32) + x_5 * x_4) >>> 32) >>> 32);
        zz_10 &= 0xFFFFFFFFL;
        long zz_12 = ((long)zz[12] & 0xFFFFFFFFL) + (zz_11 >>> 32);
        zz_11 &= 0xFFFFFFFFL;
        w = (int)(zz_6 += x_6 * x_0);
        zz[6] = w << 1 | c;
        c = w >>> 31;
        zz_7 &= 0xFFFFFFFFL;
        zz_8 &= 0xFFFFFFFFL;
        zz_9 &= 0xFFFFFFFFL;
        zz_10 &= 0xFFFFFFFFL;
        zz_11 &= 0xFFFFFFFFL;
        long x_7 = (long)x[7] & 0xFFFFFFFFL;
        long zz_13 = ((long)zz[13] & 0xFFFFFFFFL) + ((zz_12 += (zz_11 += ((zz_10 += ((zz_9 += ((zz_8 += ((zz_7 += (zz_6 >>> 32) + x_6 * x_1) >>> 32) + x_6 * x_2) >>> 32) + x_6 * x_3) >>> 32) + x_6 * x_4) >>> 32) + x_6 * x_5) >>> 32) >>> 32);
        zz_12 &= 0xFFFFFFFFL;
        long zz_14 = ((long)zz[14] & 0xFFFFFFFFL) + (zz_13 >>> 32);
        zz_13 &= 0xFFFFFFFFL;
        w = (int)(zz_7 += x_7 * x_0);
        zz[7] = w << 1 | c;
        c = w >>> 31;
        zz_14 += (zz_13 += ((zz_12 += ((zz_11 += ((zz_10 += ((zz_9 += ((zz_8 += (zz_7 >>> 32) + x_7 * x_1) >>> 32) + x_7 * x_2) >>> 32) + x_7 * x_3) >>> 32) + x_7 * x_4) >>> 32) + x_7 * x_5) >>> 32) + x_7 * x_6) >>> 32;
        w = (int)zz_8;
        zz[8] = w << 1 | c;
        c = w >>> 31;
        w = (int)zz_9;
        zz[9] = w << 1 | c;
        c = w >>> 31;
        w = (int)zz_10;
        zz[10] = w << 1 | c;
        c = w >>> 31;
        w = (int)zz_11;
        zz[11] = w << 1 | c;
        c = w >>> 31;
        w = (int)zz_12;
        zz[12] = w << 1 | c;
        c = w >>> 31;
        w = (int)zz_13;
        zz[13] = w << 1 | c;
        c = w >>> 31;
        w = (int)zz_14;
        zz[14] = w << 1 | c;
        c = w >>> 31;
        w = zz[15] + (int)(zz_14 >>> 32);
        zz[15] = w << 1 | c;
    }

    public static int subtract(int[] x, int[] y, int[] z) {
        long c = 0L;
        for (int i = 0; i < 8; ++i) {
            z[i] = (int)(c += ((long)x[i] & 0xFFFFFFFFL) - ((long)y[i] & 0xFFFFFFFFL));
            c >>= 32;
        }
        return (int)c;
    }

    public static BigInteger toBigInteger(int[] x) {
        byte[] bs = new byte[32];
        for (int i = 0; i < 8; ++i) {
            int x_i = x[i];
            if (x_i == 0) continue;
            Util.intToBigEndian(x_i, bs, 7 - i << 2);
        }
        return new BigInteger(1, bs);
    }
}

