/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.impl.base.exporter.StreamExporterDelegateBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdkZipExporterDelegate
extends StreamExporterDelegateBase<ZipOutputStream> {
    private static final Logger log = Logger.getLogger(JdkZipExporterDelegate.class.getName());

    public JdkZipExporterDelegate(Archive<?> archive) throws IllegalArgumentException {
        super(archive);
        if (archive.getContent().isEmpty()) {
            throw new IllegalArgumentException("[SHRINKWRAP-93] Cannot use this JDK-based implementation to export as ZIP an archive with no content: " + ((Object)archive).toString());
        }
    }

    @Override
    protected final void closeEntry(ZipOutputStream outputStream) throws IOException {
        outputStream.closeEntry();
    }

    @Override
    protected final ZipOutputStream createOutputStream(OutputStream out) throws IOException {
        return new ZipOutputStream(out);
    }

    @Override
    protected final void putNextExtry(ZipOutputStream outputStream, String context) throws IOException {
        outputStream.putNextEntry(new ZipEntry(context));
    }

    @Override
    protected Callable<Void> getExportTask(final Callable<Void> wrappedTask) {
        assert (wrappedTask != null) : "Wrapped task must be specified";
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    wrappedTask.call();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Exception encountered during export of archive", e);
                    Set pathsExported = JdkZipExporterDelegate.this.getExportedPaths();
                    if (pathsExported.isEmpty()) {
                        JdkZipExporterDelegate.this.latch.await();
                        JdkZipExporterDelegate.this.putNextExtry((ZipOutputStream)JdkZipExporterDelegate.this.outputStream, "dummy.txt");
                    }
                    throw e;
                }
                finally {
                    try {
                        ((ZipOutputStream)JdkZipExporterDelegate.this.outputStream).close();
                    }
                    catch (IOException ioe) {
                        log.log(Level.WARNING, "[SHRINKWRAP-120] Possible deadlock scenario: Got exception on closing the ZIP out stream: " + ioe.getMessage(), ioe);
                    }
                }
                return null;
            }
        };
    }
}

