/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.jeegen;

import java.io.File;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.rhq.helpers.jeegen.ejb.EjbArchive;

public class JeeGen {
    public static void main(String[] args) throws Exception {
        if (args.length != 5) {
            JeeGen.printUsageAndExit();
        }
        String ejbVersion = args[0];
        int entityBeanCount = 0;
        int statelessSessionBeanCount = 0;
        int statefulSessionBeanCount = 0;
        int messageDrivenBeanCount = 0;
        try {
            entityBeanCount = Integer.parseInt(args[1]);
            statelessSessionBeanCount = Integer.parseInt(args[2]);
            statefulSessionBeanCount = Integer.parseInt(args[3]);
            messageDrivenBeanCount = Integer.parseInt(args[4]);
        }
        catch (NumberFormatException e) {
            JeeGen.printUsageAndExit();
        }
        if (entityBeanCount < 0 || statelessSessionBeanCount < 0 || statefulSessionBeanCount < 0 || messageDrivenBeanCount < 0) {
            JeeGen.printUsageAndExit();
        }
        EjbArchive ejbArchive = new EjbArchive(ShrinkWrap.create(JavaArchive.class), ejbVersion, entityBeanCount, statelessSessionBeanCount, statefulSessionBeanCount, messageDrivenBeanCount);
        File ejbJarFile = new File("test-ejb.jar");
        ejbArchive.as(ZipExporter.class).exportTo(ejbJarFile, true);
    }

    private static void printUsageAndExit() {
        System.err.println("Usage: " + JeeGen.class.getName() + " EJB_VERSION ENTITY_BEAN_COUNT STATELESS_SESSION_BEAN_COUNT STATEFUL_SESSION_BEAN_COUNT MESSAGE_DRIVEN_BEAN_COUNT");
        System.err.println("Example: " + JeeGen.class.getName() + " 3.0 10 10 10 10");
        System.exit(1);
    }
}

