/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.jeegen.ejb;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.formatter.Formatter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public class EjbArchive
implements JavaArchive {
    private static final String TEST_EJB_RESOURCE_PATH = "test/ejb";
    private JavaArchive delegate;
    private static final String v2_1_AND_3_x_MDB_ELEMENTS = "         <activation-config>\n            <activation-config-property>\n               <activation-config-property-name>messageSelector</activation-config-property-name>\n               <activation-config-property-value>RECIPIENT='MDB'</activation-config-property-value>\n            </activation-config-property>\n            <activation-config-property>\n               <activation-config-property-name>destinationType</activation-config-property-name>\n               <activation-config-property-value>javax.jms.Queue</activation-config-property-value>\n            </activation-config-property>\n            <activation-config-property>\n               <activation-config-property-name>destination</activation-config-property-name>\n               <activation-config-property-value>jms/persistentQueue</activation-config-property-value>\n            </activation-config-property>\n         </activation-config>";

    public EjbArchive(JavaArchive delegate, String ejbVersion, int entityBeanCount, int statelessSessionBeanCount, int statefulSessionBeanCount, int messageDrivenBeanCount) {
        ByteArrayOutputStream byteArrayOutputStream;
        EjbVersionInfo ejbVersionInfo = EjbVersionInfo.forVersion(ejbVersion);
        this.delegate = delegate;
        Configuration config = new Configuration();
        config.setClassForTemplateLoading(this.getClass(), "");
        config.setObjectWrapper(new DefaultObjectWrapper());
        try {
            Template template = config.getTemplate("v2/ejb-jar.xml.ftl");
            HashMap<String, Object> dataModel = new HashMap<String, Object>();
            dataModel.put("name", "Test");
            dataModel.put("rootElement", ejbVersionInfo.getRootElement());
            dataModel.put("mdbElements", ejbVersionInfo.getMdbElements());
            dataModel.put("package", TEST_EJB_RESOURCE_PATH.replace('/', '.'));
            dataModel.put("entityBeanCount", entityBeanCount);
            dataModel.put("statelessSessionBeanCount", statelessSessionBeanCount);
            dataModel.put("statefulSessionBeanCount", statefulSessionBeanCount);
            dataModel.put("messageDrivenBeanCount", messageDrivenBeanCount);
            byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter(byteArrayOutputStream);
            template.process(dataModel, out);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add ejb-jar.xml to EJB-JAR.", e);
        }
        ByteArrayAsset ejbJarXml = new ByteArrayAsset(byteArrayOutputStream.toByteArray());
        this.addAsManifestResource((Asset)ejbJarXml, (ArchivePath)new BasicPath("ejb-jar.xml"));
        this.addAsResource((Asset)new ClassLoaderAsset("test/ejb/EntityEJBHome.class"), "test/ejb/EntityEJBHome.class");
        this.addAsResource((Asset)new ClassLoaderAsset("test/ejb/EntityEJBObject.class"), "test/ejb/EntityEJBObject.class");
        this.addAsResource((Asset)new ClassLoaderAsset("test/ejb/EntityBean.class"), "test/ejb/EntityBean.class");
        this.addAsResource((Asset)new ClassLoaderAsset("test/ejb/StatelessSessionEJBHome.class"), "test/ejb/StatelessSessionEJBHome.class");
        this.addAsResource((Asset)new ClassLoaderAsset("test/ejb/StatelessSessionEJBObject.class"), "test/ejb/StatelessSessionEJBObject.class");
        this.addAsResource((Asset)new ClassLoaderAsset("test/ejb/StatelessSessionBean.class"), "test/ejb/StatelessSessionBean.class");
        this.addAsResource((Asset)new ClassLoaderAsset("test/ejb/StatefulSessionEJBHome.class"), "test/ejb/StatefulSessionEJBHome.class");
        this.addAsResource((Asset)new ClassLoaderAsset("test/ejb/StatefulSessionEJBObject.class"), "test/ejb/StatefulSessionEJBObject.class");
        this.addAsResource((Asset)new ClassLoaderAsset("test/ejb/StatefulSessionBean.class"), "test/ejb/StatefulSessionBean.class");
        this.addAsResource((Asset)new ClassLoaderAsset("test/ejb/MessageDrivenBean.class"), "test/ejb/MessageDrivenBean.class");
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public JavaArchive add(Asset asset, ArchivePath target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.add(asset, target);
    }

    @Override
    public JavaArchive add(Asset asset, ArchivePath target, String name) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.add(asset, target, name);
    }

    @Override
    public JavaArchive add(Asset asset, String target, String name) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.add(asset, target, name);
    }

    @Override
    public JavaArchive add(NamedAsset namedAsset) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.add(namedAsset);
    }

    @Override
    public JavaArchive add(Asset asset, String target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.add(asset, target);
    }

    @Override
    public JavaArchive addAsDirectory(String path) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsDirectory(path);
    }

    @Override
    public JavaArchive addAsDirectories(String ... paths) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsDirectories(paths);
    }

    @Override
    public JavaArchive addAsDirectory(ArchivePath path) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsDirectory(path);
    }

    @Override
    public JavaArchive addAsDirectories(ArchivePath ... paths) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsDirectories(paths);
    }

    @Override
    public Node get(ArchivePath path) throws IllegalArgumentException {
        return this.delegate.get(path);
    }

    @Override
    public Node get(String path) throws IllegalArgumentException {
        return this.delegate.get(path);
    }

    @Override
    public <X extends Archive<X>> X getAsType(Class<X> type, String path) {
        return this.delegate.getAsType(type, path);
    }

    @Override
    public <X extends Archive<X>> X getAsType(Class<X> type, ArchivePath path) {
        return this.delegate.getAsType(type, path);
    }

    @Override
    public <X extends Archive<X>> Collection<X> getAsType(Class<X> type, Filter<ArchivePath> filter) {
        return this.delegate.getAsType(type, filter);
    }

    @Override
    public <X extends Archive<X>> X getAsType(Class<X> type, String path, ArchiveFormat archiveFormat) {
        return this.delegate.getAsType(type, path, archiveFormat);
    }

    @Override
    public <X extends Archive<X>> X getAsType(Class<X> type, ArchivePath path, ArchiveFormat archiveFormat) {
        return this.delegate.getAsType(type, path, archiveFormat);
    }

    @Override
    public <X extends Archive<X>> Collection<X> getAsType(Class<X> type, Filter<ArchivePath> filter, ArchiveFormat archiveFormat) {
        return this.delegate.getAsType(type, filter, archiveFormat);
    }

    @Override
    public boolean contains(ArchivePath path) throws IllegalArgumentException {
        return this.delegate.contains(path);
    }

    @Override
    public boolean contains(String path) throws IllegalArgumentException {
        return this.delegate.contains(path);
    }

    @Override
    public Node delete(ArchivePath path) throws IllegalArgumentException {
        return this.delegate.delete(path);
    }

    @Override
    public Node delete(String archivePath) throws IllegalArgumentException {
        return this.delegate.delete(archivePath);
    }

    @Override
    public Map<ArchivePath, Node> getContent() {
        return this.delegate.getContent();
    }

    @Override
    public Map<ArchivePath, Node> getContent(Filter<ArchivePath> filter) {
        return this.delegate.getContent(filter);
    }

    @Override
    public JavaArchive add(Archive<?> archive, ArchivePath path, Class<? extends StreamExporter> exporter) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.add(archive, path, exporter);
    }

    @Override
    public JavaArchive add(Archive<?> archive, String path, Class<? extends StreamExporter> exporter) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.add(archive, path, exporter);
    }

    @Override
    public JavaArchive merge(Archive<?> source) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.merge(source);
    }

    @Override
    public JavaArchive merge(Archive<?> source, Filter<ArchivePath> filter) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.merge(source, filter);
    }

    @Override
    public JavaArchive merge(Archive<?> source, ArchivePath path) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.merge(source, path);
    }

    @Override
    public JavaArchive merge(Archive<?> source, String path) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.merge(source, path);
    }

    @Override
    public JavaArchive merge(Archive<?> source, ArchivePath path, Filter<ArchivePath> filter) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.merge(source, path, filter);
    }

    @Override
    public JavaArchive merge(Archive<?> source, String path, Filter<ArchivePath> filter) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.merge(source, path, filter);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String toString(boolean verbose) {
        return this.delegate.toString(verbose);
    }

    @Override
    public String toString(Formatter formatter) throws IllegalArgumentException {
        return this.delegate.toString(formatter);
    }

    @Override
    public void writeTo(OutputStream outputStream, Formatter formatter) throws IllegalArgumentException {
        this.delegate.writeTo(outputStream, formatter);
    }

    @Override
    public <TYPE extends Assignable> TYPE as(Class<TYPE> clazz) {
        return this.delegate.as(clazz);
    }

    @Override
    public JavaArchive addAsServiceProviderAndClasses(Class<?> serviceInterface, Class<?> ... serviceImpls) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsServiceProviderAndClasses(serviceInterface, serviceImpls);
    }

    @Override
    public JavaArchive setManifest(String resourceName) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.setManifest(resourceName);
    }

    @Override
    public JavaArchive setManifest(File resource) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.setManifest(resource);
    }

    @Override
    public JavaArchive setManifest(URL resource) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.setManifest(resource);
    }

    @Override
    public JavaArchive setManifest(Asset resource) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.setManifest(resource);
    }

    @Override
    public JavaArchive setManifest(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.setManifest(resourcePackage, resourceName);
    }

    @Override
    public JavaArchive addAsManifestResource(String resourceName) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsManifestResource(resourceName);
    }

    @Override
    public JavaArchive addAsManifestResource(File resource) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsManifestResource(resource);
    }

    @Override
    public JavaArchive addAsManifestResource(String resourceName, String target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsManifestResource(resourceName, target);
    }

    @Override
    public JavaArchive addAsManifestResource(File resource, String target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsManifestResource(resource, target);
    }

    @Override
    public JavaArchive addAsManifestResource(URL resource, String target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsManifestResource(resource, target);
    }

    @Override
    public JavaArchive addAsManifestResource(Asset resource, String target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsManifestResource(resource, target);
    }

    @Override
    public JavaArchive addAsManifestResource(String resourceName, ArchivePath target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsManifestResource(resourceName, target);
    }

    @Override
    public JavaArchive addAsManifestResource(File resource, ArchivePath target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsManifestResource(resource, target);
    }

    @Override
    public JavaArchive addAsManifestResource(URL resource, ArchivePath target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsManifestResource(resource, target);
    }

    @Override
    public JavaArchive addAsManifestResource(Asset resource, ArchivePath target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsManifestResource(resource, target);
    }

    @Override
    public JavaArchive addAsManifestResources(Package resourcePackage, String ... resourceNames) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsManifestResources(resourcePackage, resourceNames);
    }

    @Override
    public JavaArchive addAsManifestResource(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsManifestResource(resourcePackage, resourceName);
    }

    @Override
    public JavaArchive addAsManifestResource(Package resourcePackage, String resourceName, String target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsManifestResource(resourcePackage, resourceName, target);
    }

    @Override
    public JavaArchive addAsManifestResource(Package resourcePackage, String resourceName, ArchivePath target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsManifestResource(resourcePackage, resourceName, target);
    }

    @Override
    public JavaArchive addAsServiceProvider(Class<?> serviceInterface, Class<?> ... serviceImpls) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsServiceProvider(serviceInterface, serviceImpls);
    }

    @Override
    public JavaArchive addManifest() throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addManifest();
    }

    @Override
    public JavaArchive addClass(Class<?> clazz) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addClass(clazz);
    }

    @Override
    public JavaArchive addClass(String fullyQualifiedClassName) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addClass(fullyQualifiedClassName);
    }

    @Override
    public JavaArchive addClass(String fullyQualifiedClassName, ClassLoader cl) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addClass(fullyQualifiedClassName, cl);
    }

    @Override
    public JavaArchive addClasses(Class<?> ... classes) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addClasses(classes);
    }

    @Override
    public JavaArchive addPackage(Package pack) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addPackage(pack);
    }

    @Override
    public JavaArchive addDefaultPackage() {
        return (JavaArchive)this.delegate.addDefaultPackage();
    }

    @Override
    public JavaArchive addPackages(boolean recursive, Package ... packages) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addPackages(recursive, packages);
    }

    @Override
    public JavaArchive addPackages(boolean recursive, Filter<ArchivePath> filter, Package ... packages) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addPackages(recursive, filter, packages);
    }

    @Override
    public JavaArchive addPackage(String pack) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addPackage(pack);
    }

    @Override
    public JavaArchive addPackages(boolean recursive, String ... packages) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addPackages(recursive, packages);
    }

    @Override
    public JavaArchive addPackages(boolean recursive, Filter<ArchivePath> filter, String ... packages) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addPackages(recursive, filter, packages);
    }

    @Override
    public JavaArchive addAsResource(String resourceName) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsResource(resourceName);
    }

    @Override
    public JavaArchive addAsResource(File resource) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsResource(resource);
    }

    @Override
    public JavaArchive addAsResource(String resourceName, String target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsResource(resourceName, target);
    }

    @Override
    public JavaArchive addAsResource(File resource, String target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsResource(resource, target);
    }

    @Override
    public JavaArchive addAsResource(URL resource, String target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsResource(resource, target);
    }

    @Override
    public JavaArchive addAsResource(Asset resource, String target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsResource(resource, target);
    }

    @Override
    public JavaArchive addAsResource(String resourceName, ArchivePath target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsResource(resourceName, target);
    }

    @Override
    public JavaArchive addAsResource(String resourceName, ArchivePath target, ClassLoader classLoader) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsResource(resourceName, target, classLoader);
    }

    @Override
    public JavaArchive addAsResource(File resource, ArchivePath target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsResource(resource, target);
    }

    @Override
    public JavaArchive addAsResource(URL resource, ArchivePath target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsResource(resource, target);
    }

    @Override
    public JavaArchive addAsResource(Asset resource, ArchivePath target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsResource(resource, target);
    }

    @Override
    public JavaArchive addAsResources(Package resourcePackage, String ... resourceNames) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsResources(resourcePackage, resourceNames);
    }

    @Override
    public JavaArchive addAsResource(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsResource(resourcePackage, resourceName);
    }

    @Override
    public JavaArchive addAsResource(Package resourcePackage, String resourceName, String target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsResource(resourcePackage, resourceName, target);
    }

    @Override
    public JavaArchive addAsResource(Package resourcePackage, String resourceName, ArchivePath target) throws IllegalArgumentException {
        return (JavaArchive)this.delegate.addAsResource(resourcePackage, resourceName, target);
    }

    private static enum EjbVersionInfo {
        v2_0("2.0", "<!DOCTYPE ejb-jar PUBLIC \"-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN\"\n \"http://java.sun.com/dtd/ejb-jar_2_0.dtd\">\n<ejb-jar>", "         <message-selector>RECIPIENT='MDB'</message-selector>\n         <message-driven-destination>\n            <destination-type>javax.jms.Queue</destination-type>\n         </message-driven-destination>"),
        v2_1("2.1", "<ejb-jar version=\"2.1\"\n xmlns=\"http://java.sun.com/xml/ns/j2ee\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd\">", "         <activation-config>\n            <activation-config-property>\n               <activation-config-property-name>messageSelector</activation-config-property-name>\n               <activation-config-property-value>RECIPIENT='MDB'</activation-config-property-value>\n            </activation-config-property>\n            <activation-config-property>\n               <activation-config-property-name>destinationType</activation-config-property-name>\n               <activation-config-property-value>javax.jms.Queue</activation-config-property-value>\n            </activation-config-property>\n            <activation-config-property>\n               <activation-config-property-name>destination</activation-config-property-name>\n               <activation-config-property-value>jms/persistentQueue</activation-config-property-value>\n            </activation-config-property>\n         </activation-config>"),
        v3_0("3.0", "<ejb-jar version=\"3.0\"\n xmlns=\"http://java.sun.com/xml/ns/javaee\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd\">", "         <activation-config>\n            <activation-config-property>\n               <activation-config-property-name>messageSelector</activation-config-property-name>\n               <activation-config-property-value>RECIPIENT='MDB'</activation-config-property-value>\n            </activation-config-property>\n            <activation-config-property>\n               <activation-config-property-name>destinationType</activation-config-property-name>\n               <activation-config-property-value>javax.jms.Queue</activation-config-property-value>\n            </activation-config-property>\n            <activation-config-property>\n               <activation-config-property-name>destination</activation-config-property-name>\n               <activation-config-property-value>jms/persistentQueue</activation-config-property-value>\n            </activation-config-property>\n         </activation-config>"),
        v3_1("3.1", "<ejb-jar version=\"3.1\"\n xmlns=\"http://java.sun.com/xml/ns/javaee\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/ejb-jar_3_1.xsd\">", "         <activation-config>\n            <activation-config-property>\n               <activation-config-property-name>messageSelector</activation-config-property-name>\n               <activation-config-property-value>RECIPIENT='MDB'</activation-config-property-value>\n            </activation-config-property>\n            <activation-config-property>\n               <activation-config-property-name>destinationType</activation-config-property-name>\n               <activation-config-property-value>javax.jms.Queue</activation-config-property-value>\n            </activation-config-property>\n            <activation-config-property>\n               <activation-config-property-name>destination</activation-config-property-name>\n               <activation-config-property-value>jms/persistentQueue</activation-config-property-value>\n            </activation-config-property>\n         </activation-config>");

        private String version;
        private String rootElement;
        private String mdbElements;
        private static final Map<String, EjbVersionInfo> VERSION_TO_VALUE_MAP;

        private EjbVersionInfo(String version, String rootElement, String mdbElements) {
            this.version = version;
            this.rootElement = rootElement;
            this.mdbElements = mdbElements;
        }

        public String getVersion() {
            return this.version;
        }

        public String getRootElement() {
            return this.rootElement;
        }

        public String getMdbElements() {
            return this.mdbElements;
        }

        public static EjbVersionInfo forVersion(String version) {
            if (!VERSION_TO_VALUE_MAP.containsKey(version)) {
                throw new IllegalArgumentException("Unsupported version: \"" + version + "\". The following versions are supported: " + VERSION_TO_VALUE_MAP.keySet());
            }
            return VERSION_TO_VALUE_MAP.get(version);
        }

        static {
            VERSION_TO_VALUE_MAP = new HashMap<String, EjbVersionInfo>(EjbVersionInfo.values().length);
            for (EjbVersionInfo value : EjbVersionInfo.values()) {
                VERSION_TO_VALUE_MAP.put(value.getVersion(), value);
            }
        }
    }
}

