/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.formatter.Formatter;
import org.jboss.shrinkwrap.api.formatter.Formatters;
import org.jboss.shrinkwrap.api.importer.ArchiveImportException;
import org.jboss.shrinkwrap.impl.base.ArchiveFormatStreamBindings;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.spi.ArchiveFormatAssociable;
import org.jboss.shrinkwrap.spi.Configurable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArchiveBase<T extends Archive<T>>
implements Archive<T>,
Configurable,
ArchiveFormatAssociable {
    private static final Logger log = Logger.getLogger(ArchiveBase.class.getName());
    private final String name;
    private final Configuration configuration;

    protected ArchiveBase(String name, Configuration configuration) throws IllegalArgumentException {
        Validate.notNullOrEmpty(name, "name must be specified");
        Validate.notNull(configuration, "configuration must be specified");
        this.name = name;
        this.configuration = configuration;
    }

    @Override
    public ArchiveFormat getArchiveFormat() {
        return ArchiveFormat.UNKNOWN;
    }

    @Override
    public T add(Asset asset, String target) throws IllegalArgumentException {
        Validate.notNullOrEmpty(target, "target must be specified");
        Validate.notNull(asset, "asset must be specified");
        BasicPath path = new BasicPath(target);
        return this.add(asset, path);
    }

    @Override
    public T add(Asset asset, String target, String name) throws IllegalArgumentException {
        Validate.notNull(target, "target must be specified");
        ArchivePath path = ArchivePaths.create(target);
        return this.add(asset, path, name);
    }

    @Override
    public T add(Asset asset, ArchivePath path, String name) {
        Validate.notNull(path, "No path was specified");
        Validate.notNullOrEmpty(name, "No target name name was specified");
        Validate.notNull(asset, "No asset was was specified");
        BasicPath resolvedPath = new BasicPath(path, name);
        return this.add(asset, resolvedPath);
    }

    @Override
    public Node get(String path) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, "No path was specified");
        BasicPath realPath = new BasicPath(path);
        return this.get(realPath);
    }

    @Override
    public <X extends Archive<X>> X getAsType(Class<X> type, String path) {
        Validate.notNull(path, "Path must be specified");
        return this.getAsType(type, ArchivePaths.create(path));
    }

    @Override
    public <X extends Archive<X>> Collection<X> getAsType(Class<X> type, Filter<ArchivePath> filter) {
        Validate.notNull(type, "Type must be specified");
        Validate.notNull(filter, "Filter must be specified");
        ArrayList<X> archives = new ArrayList<X>();
        Map<ArchivePath, Node> matches = this.getContent(filter);
        for (ArchivePath path : matches.keySet()) {
            archives.add(this.getAsType(type, path));
        }
        return archives;
    }

    @Override
    public <X extends Archive<X>> X getAsType(Class<X> type, ArchivePath path) {
        Validate.notNull(type, "Type must be specified");
        Validate.notNull(path, "ArchivePath must be specified");
        Node content = this.get(path);
        if (content == null) {
            return null;
        }
        Asset asset = content.getAsset();
        if (asset == null) {
            return null;
        }
        if (asset instanceof ArchiveAsset) {
            ArchiveAsset archiveAsset = (ArchiveAsset)asset;
            return (X)((Archive)archiveAsset.getArchive().as(type));
        }
        ArchiveFormat archiveFormat = this.configuration.getExtensionLoader().getArchiveFormatFromExtensionMapping(type);
        return this.getAsType(type, path, archiveFormat);
    }

    @Override
    public <X extends Archive<X>> X getAsType(Class<X> type, String path, ArchiveFormat archiveFormat) {
        Validate.notNull(path, "ArchiveFormat must be specified");
        return this.getAsType(type, ArchivePaths.create(path), archiveFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X extends Archive<X>> X getAsType(Class<X> type, ArchivePath path, ArchiveFormat archiveFormat) {
        Validate.notNull(type, "Type must be specified");
        Validate.notNull(path, "ArchivePath must be specified");
        Validate.notNull((Object)archiveFormat, "ArchiveFormat must be specified");
        ArchiveFormatStreamBindings formatBinding = new ArchiveFormatStreamBindings(archiveFormat);
        Node content = this.get(path);
        if (content == null) {
            return null;
        }
        Asset asset = content.getAsset();
        if (asset == null) {
            return null;
        }
        InputStream stream = null;
        try {
            stream = asset.openStream();
            Archive archive = (Archive)ShrinkWrap.create(formatBinding.getImporter(), path.get()).importFrom(stream).as(type);
            this.delete(path);
            this.add((Asset)new ArchiveAsset(archive, formatBinding.getExporter()), path);
            Archive archive2 = archive;
            return (X)archive2;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new ArchiveImportException("Stream not closed after import", e);
                }
            }
        }
    }

    @Override
    public <X extends Archive<X>> Collection<X> getAsType(Class<X> type, Filter<ArchivePath> filter, ArchiveFormat archiveFormat) {
        Validate.notNull(type, "Type must be specified");
        Validate.notNull(filter, "Filter must be specified");
        Validate.notNull((Object)archiveFormat, "ArchiveFormat must be specified");
        ArrayList<X> archives = new ArrayList<X>();
        Map<ArchivePath, Node> matches = this.getContent(filter);
        for (ArchivePath path : matches.keySet()) {
            archives.add(this.getAsType(type, path, archiveFormat));
        }
        return archives;
    }

    @Override
    public T add(Archive<?> archive, ArchivePath path, Class<? extends StreamExporter> exporter) {
        Validate.notNull(path, "No path was specified");
        Validate.notNull(archive, "No archive was specified");
        Validate.notNull(exporter, "No exporter was specified");
        String archiveName = archive.getName();
        BasicPath contentPath = new BasicPath(path, archiveName);
        ArchiveAsset archiveAsset = new ArchiveAsset(archive, exporter);
        return this.add((Asset)archiveAsset, contentPath);
    }

    @Override
    public T add(NamedAsset namedAsset) {
        Validate.notNull(namedAsset, "No named asset was specified");
        return this.add((Asset)namedAsset, namedAsset.getName());
    }

    @Override
    public T addAsDirectory(String path) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, "path must be specified");
        return this.addAsDirectory(ArchivePaths.create(path));
    }

    @Override
    public T addAsDirectories(ArchivePath ... paths) throws IllegalArgumentException {
        Validate.notNull(paths, "paths must be specified");
        for (ArchivePath path : paths) {
            this.addAsDirectory(path);
        }
        return this.covariantReturn();
    }

    @Override
    public T addAsDirectories(String ... paths) throws IllegalArgumentException {
        Validate.notNull(paths, "paths must be specified");
        ArrayList<ArchivePath> pathsCollection = new ArrayList<ArchivePath>(paths.length);
        for (String path : paths) {
            pathsCollection.add(ArchivePaths.create(path));
        }
        return this.addAsDirectories(pathsCollection.toArray(new ArchivePath[0]));
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public T merge(Archive<?> source) throws IllegalArgumentException {
        return this.merge(source, new BasicPath());
    }

    @Override
    public T merge(Archive<?> source, Filter<ArchivePath> filter) throws IllegalArgumentException {
        return this.merge(source, new BasicPath(), filter);
    }

    @Override
    public T merge(Archive<?> source, ArchivePath path) throws IllegalArgumentException {
        Validate.notNull(source, "No source archive was specified");
        Validate.notNull(path, "No path was specified");
        return this.merge(source, path, Filters.includeAll());
    }

    @Override
    public T merge(Archive<?> source, String path, Filter<ArchivePath> filter) throws IllegalArgumentException {
        Validate.notNull(path, "path must be specified");
        return this.merge(source, ArchivePaths.create(path), filter);
    }

    @Override
    public T merge(Archive<?> source, String path) throws IllegalArgumentException {
        Validate.notNull(path, "path must be specified");
        return this.merge(source, ArchivePaths.create(path));
    }

    @Override
    public T merge(Archive<?> source, ArchivePath path, Filter<ArchivePath> filter) throws IllegalArgumentException {
        Validate.notNull(source, "No source archive was specified");
        Validate.notNull(path, "No path was specified");
        Validate.notNull(filter, "No filter was specified");
        Map<ArchivePath, Node> sourceContent = source.getContent();
        Validate.notNull(sourceContent, "Source archive content can not be null.");
        for (Map.Entry<ArchivePath, Node> contentEntry : sourceContent.entrySet()) {
            Node node = contentEntry.getValue();
            BasicPath nodePath = new BasicPath(path, contentEntry.getKey());
            if (!filter.include(nodePath)) continue;
            if (node.getAsset() == null) {
                this.addAsDirectory(nodePath);
                continue;
            }
            this.add(node.getAsset(), nodePath);
        }
        return this.covariantReturn();
    }

    @Override
    public <TYPE extends Assignable> TYPE as(Class<TYPE> clazz) {
        Validate.notNull(clazz, "Class must be specified");
        return this.configuration.getExtensionLoader().load(clazz, this);
    }

    @Override
    public String toString() {
        return this.toString(Formatters.SIMPLE);
    }

    @Override
    public String toString(boolean verbose) {
        return verbose ? this.toString(Formatters.VERBOSE) : this.toString();
    }

    @Override
    public String toString(Formatter formatter) throws IllegalArgumentException {
        if (formatter == null) {
            throw new IllegalArgumentException("Formatter must be specified");
        }
        return formatter.format(this);
    }

    @Override
    public void writeTo(OutputStream outputStream, Formatter formatter) throws IllegalArgumentException {
        try {
            IOUtil.bufferedWriteWithFlush(outputStream, this.toString(formatter).getBytes());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not write Archive contents to specified OutputStream", ioe);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getContent() == null ? 0 : ((Object)this.getContent()).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveBase)) {
            return false;
        }
        ArchiveBase other = (ArchiveBase)obj;
        if (this.getContent() == null ? other.getContent() != null : !((Object)this.getContent()).equals(other.getContent())) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected abstract Class<T> getActualClass();

    protected final T covariantReturn() {
        try {
            return (T)((Archive)this.getActualClass().cast(this));
        }
        catch (ClassCastException cce) {
            log.log(Level.SEVERE, "The class specified by getActualClass is not a valid assignment target for this instance; developer error");
            throw cce;
        }
    }
}

