/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.exporter.ArchiveExportException;
import org.jboss.shrinkwrap.impl.base.exporter.AbstractExporterDelegate;
import org.jboss.shrinkwrap.impl.base.exporter.FutureCompletionInputStream;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.io.StreamErrorHandler;
import org.jboss.shrinkwrap.impl.base.io.StreamTask;
import org.jboss.shrinkwrap.impl.base.path.PathUtil;
import org.jboss.shrinkwrap.spi.Configurable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StreamExporterDelegateBase<O extends OutputStream>
extends AbstractExporterDelegate<InputStream> {
    private static final Logger log = Logger.getLogger(StreamExporterDelegateBase.class.getName());
    protected O outputStream;
    private InputStream inputStream;
    private Set<ArchivePath> pathsExported = new HashSet<ArchivePath>();
    protected final CountDownLatch latch = new CountDownLatch(1);

    public StreamExporterDelegateBase(Archive<?> archive) throws IllegalArgumentException {
        super(archive);
    }

    protected abstract Callable<Void> getExportTask(Callable<Void> var1);

    @Override
    protected void doExport() {
        PipedOutputStream output;
        Callable<Void> exportTask = this.getExportTask(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                StreamExporterDelegateBase.super.doExport();
                return null;
            }
        });
        boolean executorServiceIsOurs = false;
        ExecutorService service = this.getArchive().as(Configurable.class).getConfiguration().getExecutorService();
        if (service == null) {
            service = Executors.newSingleThreadExecutor();
            executorServiceIsOurs = true;
        }
        Future<Void> job = service.submit(exportTask);
        if (executorServiceIsOurs) {
            service.shutdown();
        }
        FutureCompletionInputStream input = new FutureCompletionInputStream(job);
        this.inputStream = input;
        try {
            output = new PipedOutputStream(input);
        }
        catch (IOException e) {
            throw new RuntimeException("Error in setting up output stream", e);
        }
        try {
            this.outputStream = this.createOutputStream(output);
        }
        catch (IOException e) {
            throw new ArchiveExportException("Could not create the underlying stream to export: " + ((Object)this.getArchive()).toString(), e);
        }
        this.latch.countDown();
    }

    protected abstract void putNextExtry(O var1, String var2) throws IOException;

    protected abstract void closeEntry(O var1) throws IOException;

    protected abstract O createOutputStream(OutputStream var1) throws IOException;

    @Override
    protected void processNode(final ArchivePath path, Node node) {
        if (path == null) {
            throw new IllegalArgumentException("Path must be specified");
        }
        if (node == null) {
            throw new IllegalArgumentException("asset must be specified");
        }
        final boolean isDirectory = node.getAsset() == null;
        InputStream stream = null;
        if (!isDirectory) {
            stream = node.getAsset().openStream();
        }
        final String pathName = PathUtil.optionallyRemovePrecedingSlash(path.get());
        IOUtil.closeOnComplete(stream, new StreamTask<InputStream>(){

            @Override
            public void execute(InputStream stream) throws Exception {
                String resolvedPath = pathName;
                if (isDirectory) {
                    resolvedPath = PathUtil.optionallyAppendSlash(resolvedPath);
                }
                StreamExporterDelegateBase.this.latch.await();
                try {
                    StreamExporterDelegateBase.this.putNextExtry(StreamExporterDelegateBase.this.outputStream, resolvedPath);
                }
                catch (IOException ze) {
                    log.log(Level.SEVERE, StreamExporterDelegateBase.this.pathsExported.toString());
                    throw new RuntimeException(ze);
                }
                StreamExporterDelegateBase.this.pathsExported.add(path);
                if (!isDirectory) {
                    IOUtil.copy(stream, StreamExporterDelegateBase.this.outputStream);
                }
                StreamExporterDelegateBase.this.closeEntry(StreamExporterDelegateBase.this.outputStream);
            }
        }, new StreamErrorHandler(){

            public void handle(Throwable t) {
                throw new ArchiveExportException("Failed to write asset to output: " + path.get(), t);
            }
        });
    }

    @Override
    protected InputStream getResult() {
        return this.inputStream;
    }

    protected final Set<ArchivePath> getExportedPaths() {
        return Collections.unmodifiableSet(this.pathsExported);
    }
}

