/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.clients.ptrans;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.CharsetUtil;
import java.util.List;
import java.util.Properties;
import org.rhq.metrics.clients.ptrans.backend.RestForwardingHandler;
import org.rhq.metrics.clients.ptrans.graphite.GraphiteEventDecoder;
import org.rhq.metrics.clients.ptrans.syslog.SyslogEventDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemuxHandler
extends ByteToMessageDecoder {
    private static final Logger logger = LoggerFactory.getLogger(DemuxHandler.class);
    private Properties configuration;
    private ChannelInboundHandlerAdapter forwardingHandler;

    public DemuxHandler(Properties configuration, ChannelInboundHandlerAdapter forwardingHandler) {
        this.configuration = configuration;
        this.forwardingHandler = forwardingHandler;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List out) throws Exception {
        String[] items;
        if (msg.readableBytes() < 5) {
            msg.clear();
            ctx.close();
            return;
        }
        ChannelPipeline pipeline = ctx.pipeline();
        String data = msg.toString(CharsetUtil.UTF_8);
        if (logger.isDebugEnabled()) {
            logger.debug("Incoming: [" + data + "]");
        }
        boolean done = false;
        if (data.contains("type=metric")) {
            pipeline.addLast(new ChannelHandler[]{new SyslogEventDecoder()});
            pipeline.addLast("forwarder", (ChannelHandler)new RestForwardingHandler(this.configuration));
            pipeline.remove((ChannelHandler)this);
            done = true;
        } else if (!data.contains("=") && (items = data.split(" |\\n")).length % 3 == 0) {
            pipeline.addLast("encoder", (ChannelHandler)new GraphiteEventDecoder());
            pipeline.addLast("forwarder", (ChannelHandler)this.forwardingHandler);
            pipeline.remove((ChannelHandler)this);
            done = true;
        }
        if (!done) {
            logger.warn("Unknown input [" + data + "], ignoring");
            msg.clear();
            ctx.close();
        }
    }
}

