/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.clients.ptrans;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.Future;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.rhq.metrics.clients.ptrans.DemuxHandler;
import org.rhq.metrics.clients.ptrans.MetricBatcher;
import org.rhq.metrics.clients.ptrans.backend.RestForwardingHandler;
import org.rhq.metrics.clients.ptrans.collectd.CollectdEventHandler;
import org.rhq.metrics.clients.ptrans.ganglia.UdpGangliaDecoder;
import org.rhq.metrics.clients.ptrans.statsd.StatsdDecoder;
import org.rhq.metrics.clients.ptrans.syslog.UdpSyslogEventDecoder;
import org.rhq.metrics.netty.collectd.event.CollectdEventsDecoder;
import org.rhq.metrics.netty.collectd.packet.CollectdPacketDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static final String HELP_OPT = "h";
    private static final String HELP_LONGOPT = "help";
    private static final String CONFIG_FILE_OPT = "c";
    private static final String CONFIG_FILE_LONGOPT = "config-file";
    private static final int DEFAULT_PORT = 5140;
    private static final int GANGLIA_DEFAULT_PORT = 8649;
    private static final String GANGLIA_DEFAULT_GROUP = "239.2.11.71";
    private static final int STATSD_DEFAULT_PORT = 8125;
    private static final int COLLETCD_DEFAULT_PORT = 25826;
    private String gangliaGroup = "239.2.11.71";
    private int gangliaPort = 8649;
    private String multicastIfOverride;
    private int tcpPort = 5140;
    private int udpPort = 5140;
    private int statsDport = 8125;
    private int collectdPort = 25826;
    private final int minimumBatchSize;
    private final Properties configuration;
    private final EventLoopGroup group = new NioEventLoopGroup();
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();

    public static void main(String[] args) throws Exception {
        File configFile;
        Options options = Main.getCommandOptions();
        PosixParser parser = new PosixParser();
        boolean commandLineError = false;
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args, true);
        }
        catch (MissingOptionException e) {
            commandLineError = true;
            System.err.println(e.getMessage());
        }
        if (commandLineError || cmd.hasOption(HELP_OPT)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(Integer.MAX_VALUE);
            formatter.printHelp("java -jar ptrans-all.jar", options, true);
            System.exit(commandLineError ? 1 : 0);
        }
        if (!(configFile = new File(cmd.getOptionValue(CONFIG_FILE_OPT))).isFile()) {
            System.err.println("Configuration file " + configFile.getAbsolutePath() + " does not exist or is not readable.");
            System.exit(1);
        }
        Main main = new Main(configFile);
        main.run();
    }

    private static Options getCommandOptions() {
        Options options = new Options();
        Option helpOption = new Option(HELP_OPT, HELP_LONGOPT, false, "Print usage and exit.");
        options.addOption(helpOption);
        Option configOption = new Option(CONFIG_FILE_OPT, CONFIG_FILE_LONGOPT, true, "Set the path to the configuration file.");
        configOption.setRequired(true);
        options.addOption(configOption);
        return options;
    }

    private Main(File configFile) {
        this.configuration = this.loadConfigurationFromProperties(configFile);
        this.loadPortsFromProperties(this.configuration);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                Main.this.stop();
            }
        }));
        this.minimumBatchSize = Integer.parseInt(this.configuration.getProperty("batch.size", "5"));
    }

    private void run() throws Exception {
        final RestForwardingHandler forwardingHandler = new RestForwardingHandler(this.configuration);
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.group, this.workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.tcpPort)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel socketChannel) throws Exception {
                ChannelPipeline pipeline = socketChannel.pipeline();
                pipeline.addLast(new ChannelHandler[]{new DemuxHandler(Main.this.configuration, forwardingHandler)});
            }
        });
        ChannelFuture graphiteFuture = serverBootstrap.bind().sync();
        logger.info("Server listening on TCP " + graphiteFuture.channel().localAddress());
        graphiteFuture.channel().closeFuture();
        Bootstrap udpBootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)udpBootstrap.group(this.group)).channel(NioDatagramChannel.class)).localAddress(this.udpPort)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel socketChannel) throws Exception {
                ChannelPipeline pipeline = socketChannel.pipeline();
                pipeline.addLast(new ChannelHandler[]{new UdpSyslogEventDecoder()});
                pipeline.addLast(new ChannelHandler[]{forwardingHandler});
            }
        });
        ChannelFuture udpFuture = udpBootstrap.bind().sync();
        logger.info("Syslogd listening on udp " + udpFuture.channel().localAddress());
        this.setupGangliaUdp(this.group, forwardingHandler);
        this.setupStatsdUdp(this.group, forwardingHandler);
        this.setupCollectdUdp(this.group, forwardingHandler);
        udpFuture.channel().closeFuture().sync();
    }

    private void stop() {
        logger.info("Stopping ptrans...");
        Future groupShutdownFuture = this.group.shutdownGracefully();
        Future workerGroupShutdownFuture = this.workerGroup.shutdownGracefully();
        try {
            groupShutdownFuture.sync();
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        try {
            workerGroupShutdownFuture.sync();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("Stopped");
    }

    private void setupCollectdUdp(EventLoopGroup group, final ChannelInboundHandlerAdapter forwardingHandler) {
        Bootstrap collectdBootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)collectdBootstrap.group(group)).channel(NioDatagramChannel.class)).localAddress(this.collectdPort)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel socketChannel) throws Exception {
                ChannelPipeline pipeline = socketChannel.pipeline();
                pipeline.addLast(new ChannelHandler[]{new CollectdPacketDecoder()});
                pipeline.addLast(new ChannelHandler[]{new CollectdEventsDecoder()});
                pipeline.addLast(new ChannelHandler[]{new CollectdEventHandler()});
                pipeline.addLast(new ChannelHandler[]{new MetricBatcher("collectd", Main.this.minimumBatchSize)});
                pipeline.addLast(new ChannelHandler[]{forwardingHandler});
            }
        });
        try {
            ChannelFuture collectdFuture = collectdBootstrap.bind().sync();
            logger.info("Collectd listening on udp " + collectdFuture.channel().localAddress());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void setupStatsdUdp(EventLoopGroup group, final ChannelInboundHandlerAdapter forwardingHandler) {
        Bootstrap statsdBootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)statsdBootstrap.group(group)).channel(NioDatagramChannel.class)).localAddress(this.statsDport)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel socketChannel) throws Exception {
                ChannelPipeline pipeline = socketChannel.pipeline();
                pipeline.addLast(new ChannelHandler[]{new StatsdDecoder()});
                pipeline.addLast(new ChannelHandler[]{new MetricBatcher("statsd", Main.this.minimumBatchSize)});
                pipeline.addLast(new ChannelHandler[]{forwardingHandler});
            }
        });
        try {
            ChannelFuture statsdFuture = statsdBootstrap.bind().sync();
            logger.info("Statsd listening on udp " + statsdFuture.channel().localAddress());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void setupGangliaUdp(EventLoopGroup group, final ChannelInboundHandlerAdapter fowardingHandler) {
        try {
            NetworkInterface mcIf;
            if (this.multicastIfOverride == null) {
                Inet4Address hostAddr = (Inet4Address)InetAddress.getLocalHost();
                mcIf = NetworkInterface.getByInetAddress(hostAddr);
            } else {
                mcIf = NetworkInterface.getByName(this.multicastIfOverride);
            }
            InetSocketAddress gangliaSocket = new InetSocketAddress(this.gangliaGroup, this.gangliaPort);
            Bootstrap gangliaBootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)gangliaBootstrap.group(group)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.IP_MULTICAST_IF, (Object)mcIf)).localAddress((SocketAddress)gangliaSocket)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                public void initChannel(Channel socketChannel) throws Exception {
                    ChannelPipeline pipeline = socketChannel.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new UdpGangliaDecoder()});
                    pipeline.addLast(new ChannelHandler[]{new MetricBatcher("ganglia", Main.this.minimumBatchSize)});
                    pipeline.addLast(new ChannelHandler[]{fowardingHandler});
                }
            });
            logger.info("Bootstrap is " + gangliaBootstrap);
            ChannelFuture gangliaFuture = gangliaBootstrap.bind().sync();
            logger.info("Ganglia listening on udp " + gangliaFuture.channel().localAddress());
            DatagramChannel channel = (DatagramChannel)gangliaFuture.channel();
            channel.joinGroup(gangliaSocket, mcIf).sync();
            logger.info("Joined the group");
            channel.closeFuture();
        }
        catch (InterruptedException | SocketException | UnknownHostException e) {
            logger.warn("Setup of udp multicast for Ganglia failed");
            e.printStackTrace();
        }
    }

    private Properties loadConfigurationFromProperties(File configFile) {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(configFile);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            logger.warn("Can not load properties from '" + configFile.getAbsolutePath() + "'");
        }
        return properties;
    }

    private void loadPortsFromProperties(Properties configuration) {
        this.udpPort = Integer.parseInt(configuration.getProperty("port.udp", String.valueOf(5140)));
        this.tcpPort = Integer.parseInt(configuration.getProperty("port.tcp", String.valueOf(5140)));
        this.gangliaGroup = configuration.getProperty("ganglia.group", GANGLIA_DEFAULT_GROUP);
        this.gangliaPort = Integer.parseInt(configuration.getProperty("ganglia.port", String.valueOf(8649)));
        this.multicastIfOverride = configuration.getProperty("multicast.interface");
        this.statsDport = Integer.parseInt(configuration.getProperty("statsd.port", String.valueOf(8125)));
        this.collectdPort = Integer.parseInt(configuration.getProperty("collectd.port", String.valueOf(25826)));
    }
}

