/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.clients.ptrans;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.AttributeKey;
import java.util.ArrayList;
import java.util.List;
import org.rhq.metrics.client.common.SingleMetric;

public class MetricBatcher
extends MessageToMessageDecoder<SingleMetric> {
    private int minimumBatchSize;
    AttributeKey<List<SingleMetric>> cacheKey;

    public MetricBatcher(String subKey, int minimumBatchSize) {
        this.minimumBatchSize = minimumBatchSize;
        if (this.minimumBatchSize < 1) {
            this.minimumBatchSize = 1;
        }
        this.cacheKey = AttributeKey.valueOf((String)("cachedMetrics." + subKey));
    }

    protected void decode(ChannelHandlerContext ctx, SingleMetric msg, List<Object> out) throws Exception {
        ArrayList<SingleMetric> cached = (ArrayList<SingleMetric>)ctx.attr(this.cacheKey).get();
        if (cached == null) {
            cached = new ArrayList<SingleMetric>(this.minimumBatchSize);
            ctx.attr(this.cacheKey).set(cached);
        }
        if (cached.size() >= this.minimumBatchSize) {
            ArrayList<SingleMetric> toForward = new ArrayList<SingleMetric>(cached.size() + 1);
            toForward.addAll(cached);
            toForward.add(msg);
            cached.clear();
            out.add(toForward);
        } else {
            cached.add(msg);
        }
    }
}

