/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.pattern;

import java.util.Date;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternComponent
implements ResourceComponent,
MeasurementFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    int count = 0;
    int number = 0;
    int[] wanted = new int[2];

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public void start(ResourceContext context) throws InvalidPluginConfigurationException {
        Configuration conf = context.getPluginConfiguration();
        String tmp = conf.getSimpleValue("ones", "1");
        int wantedOnes = Integer.parseInt(tmp);
        if (wantedOnes < 1) {
            throw new InvalidPluginConfigurationException("Ones must be > 0");
        }
        tmp = conf.getSimpleValue("zeros", "1");
        int wantedZeros = Integer.parseInt(tmp);
        if (wantedZeros < 1) {
            throw new InvalidPluginConfigurationException("Zeros must be > 0");
        }
        this.wanted[0] = wantedZeros;
        this.wanted[1] = wantedOnes;
    }

    public void stop() {
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        for (MeasurementScheduleRequest req : metrics) {
            if (!req.getName().equals("pattern1")) continue;
            double val = this.number;
            if (this.number == 1) {
                System.out.println("XX 1 _ " + new Date());
            }
            ++this.count;
            if (this.count >= this.wanted[this.number]) {
                this.number = 1 - this.number;
                this.count = 0;
            }
            MeasurementDataNumeric res = new MeasurementDataNumeric(req, Double.valueOf(val));
            report.addData(res);
        }
    }
}

