/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.http;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractMapAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractZonedDateTimeAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.TemporalOffset;
import org.springframework.http.HttpHeaders;

public class HttpHeadersAssert
extends AbstractMapAssert<HttpHeadersAssert, HttpHeaders, String, List<String>> {
    private static final ZoneId GMT = ZoneId.of("GMT");

    public HttpHeadersAssert(HttpHeaders actual) {
        super((Map)actual, HttpHeadersAssert.class);
        this.as("HTTP headers", new Object[0]);
    }

    public HttpHeadersAssert containsHeader(String name) {
        return (HttpHeadersAssert)this.containsKey(name);
    }

    public HttpHeadersAssert containsHeaders(String ... names) {
        return (HttpHeadersAssert)this.containsKeys(names);
    }

    public HttpHeadersAssert doesNotContainHeader(String name) {
        return (HttpHeadersAssert)this.doesNotContainKey(name);
    }

    public HttpHeadersAssert doesNotContainsHeaders(String ... names) {
        return (HttpHeadersAssert)this.doesNotContainKeys(names);
    }

    public HttpHeadersAssert hasValue(String name, String value) {
        this.containsKey(name);
        ((AbstractStringAssert)Assertions.assertThat((String)((HttpHeaders)this.actual).getFirst(name)).as("check primary value for HTTP header '%s'", new Object[]{name})).isEqualTo(value);
        return (HttpHeadersAssert)this.myself;
    }

    public HttpHeadersAssert hasValue(String name, long value) {
        this.containsKey(name);
        ((AbstractStringAssert)Assertions.assertThat((String)((HttpHeaders)this.actual).getFirst(name)).as("check primary long value for HTTP header '%s'", new Object[]{name})).asLong().isEqualTo(value);
        return (HttpHeadersAssert)this.myself;
    }

    public HttpHeadersAssert hasValue(String name, Instant value) {
        this.containsKey(name);
        ((AbstractZonedDateTimeAssert)Assertions.assertThat((ZonedDateTime)((HttpHeaders)this.actual).getFirstZonedDateTime(name)).as("check primary date value for HTTP header '%s'", new Object[]{name})).isCloseTo(ZonedDateTime.ofInstant(value, GMT), (TemporalOffset)Assertions.within((long)999L, (TemporalUnit)ChronoUnit.MILLIS));
        return (HttpHeadersAssert)this.myself;
    }
}

