/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.result.PrintingResultHandler;
import org.springframework.util.CollectionUtils;

public abstract class MockMvcResultHandlers {
    private static final Log logger = LogFactory.getLog((String)"org.springframework.test.web.servlet.result");

    public static ResultHandler log() {
        return new LoggingResultHandler();
    }

    public static ResultHandler print() {
        return MockMvcResultHandlers.print(System.out);
    }

    public static ResultHandler print(OutputStream stream) {
        return new PrintWriterPrintingResultHandler(new PrintWriter(stream, true));
    }

    public static ResultHandler print(Writer writer) {
        return new PrintWriterPrintingResultHandler(new PrintWriter(writer, true));
    }

    private static class LoggingResultHandler
    implements ResultHandler {
        private LoggingResultHandler() {
        }

        @Override
        public void handle(MvcResult result) throws Exception {
            if (logger.isDebugEnabled()) {
                StringWriter stringWriter = new StringWriter();
                PrintWriterPrintingResultHandler printingResultHandler = new PrintWriterPrintingResultHandler(new PrintWriter(stringWriter));
                printingResultHandler.handle(result);
                logger.debug((Object)("MvcResult details:\n" + stringWriter));
            }
        }
    }

    private static class PrintWriterPrintingResultHandler
    extends PrintingResultHandler {
        public PrintWriterPrintingResultHandler(final PrintWriter writer) {
            super(new PrintingResultHandler.ResultValuePrinter(){

                @Override
                public void printHeading(String heading) {
                    writer.println();
                    writer.println(String.format("%s:", heading));
                }

                @Override
                public void printValue(String label, @Nullable Object value) {
                    if (value != null && value.getClass().isArray()) {
                        value = CollectionUtils.arrayToList((Object)value);
                    }
                    writer.println(String.format("%17s = %s", label, value));
                }
            });
        }
    }
}

