/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelId;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseCookie;
import org.springframework.http.ZeroCopyHttpOutputMessage;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.support.Netty4HeadersAdapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ChannelOperationsId;
import reactor.netty.http.server.HttpServerResponse;

class ReactorServerHttpResponse
extends AbstractServerHttpResponse
implements ZeroCopyHttpOutputMessage {
    private static final Log logger = LogFactory.getLog(ReactorServerHttpResponse.class);
    private final HttpServerResponse response;

    public ReactorServerHttpResponse(HttpServerResponse response, DataBufferFactory bufferFactory) {
        super(bufferFactory, new HttpHeaders(new Netty4HeadersAdapter(Objects.requireNonNull(response, "HttpServerResponse must not be null").responseHeaders())));
        this.response = response;
    }

    @Override
    public <T> T getNativeResponse() {
        return (T)this.response;
    }

    @Override
    public HttpStatusCode getStatusCode() {
        HttpStatusCode status = super.getStatusCode();
        return status != null ? status : HttpStatusCode.valueOf(this.response.status().code());
    }

    @Override
    @Deprecated
    public Integer getRawStatusCode() {
        Integer status = super.getRawStatusCode();
        return status != null ? status.intValue() : this.response.status().code();
    }

    @Override
    protected void applyStatusCode() {
        HttpStatusCode status = super.getStatusCode();
        if (status != null) {
            this.response.status(status.value());
        }
    }

    @Override
    protected Mono<Void> writeWithInternal(Publisher<? extends DataBuffer> publisher) {
        return this.response.send(this.toByteBufs(publisher)).then();
    }

    @Override
    protected Mono<Void> writeAndFlushWithInternal(Publisher<? extends Publisher<? extends DataBuffer>> publisher) {
        return this.response.sendGroups((Publisher)Flux.from(publisher).map(this::toByteBufs)).then();
    }

    @Override
    protected void applyHeaders() {
    }

    @Override
    protected void applyCookies() {
        for (List cookies : this.getCookies().values()) {
            for (ResponseCookie cookie : cookies) {
                this.response.addHeader((CharSequence)"Set-Cookie", (CharSequence)cookie.toString());
            }
        }
    }

    @Override
    public Mono<Void> writeWith(Path file, long position, long count) {
        return this.doCommit(() -> this.response.sendFile(file, position, count).then());
    }

    private Publisher<ByteBuf> toByteBufs(Publisher<? extends DataBuffer> dataBuffers) {
        return dataBuffers instanceof Mono ? Mono.from(dataBuffers).map(NettyDataBufferFactory::toByteBuf) : Flux.from(dataBuffers).map(NettyDataBufferFactory::toByteBuf);
    }

    @Override
    protected void touchDataBuffer(DataBuffer buffer) {
        if (logger.isDebugEnabled()) {
            HttpServerResponse httpServerResponse = this.response;
            if (httpServerResponse instanceof ChannelOperationsId) {
                ChannelOperationsId operationsId = (ChannelOperationsId)httpServerResponse;
                DataBufferUtils.touch((DataBuffer)buffer, (Object)("Channel id: " + operationsId.asLongText()));
            } else {
                this.response.withConnection(connection -> {
                    ChannelId id = connection.channel().id();
                    DataBufferUtils.touch((DataBuffer)buffer, (Object)("Channel id: " + id.asShortText()));
                });
            }
        }
    }
}

