/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.commons;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.multipart.support.DefaultMultipartHttpServletRequest;
import org.springframework.web.util.WebUtils;

public class CommonsMultipartResolver
implements MultipartResolver,
ServletContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private DiskFileUpload fileUpload = this.newFileUpload();
    private String defaultEncoding = "ISO-8859-1";
    private File uploadTempDir;

    public CommonsMultipartResolver() {
    }

    public CommonsMultipartResolver(ServletContext servletContext) {
        this();
        this.setServletContext(servletContext);
    }

    protected DiskFileUpload newFileUpload() {
        return new DiskFileUpload();
    }

    public DiskFileUpload getFileUpload() {
        return this.fileUpload;
    }

    public void setMaxUploadSize(long maxUploadSize) {
        this.fileUpload.setSizeMax(maxUploadSize);
    }

    public void setMaxInMemorySize(int maxInMemorySize) {
        this.fileUpload.setSizeThreshold(maxInMemorySize);
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        this.fileUpload.setHeaderEncoding(defaultEncoding);
    }

    public void setUploadTempDir(Resource uploadTempDir) throws IOException {
        if (!uploadTempDir.exists() && !uploadTempDir.getFile().mkdirs()) {
            throw new IllegalArgumentException("Given uploadTempDir [" + uploadTempDir + "] could not be created");
        }
        this.uploadTempDir = uploadTempDir.getFile();
        this.fileUpload.setRepositoryPath(uploadTempDir.getFile().getAbsolutePath());
    }

    public void setServletContext(ServletContext servletContext) {
        if (this.uploadTempDir == null) {
            this.fileUpload.setRepositoryPath(WebUtils.getTempDir(servletContext).getAbsolutePath());
        }
    }

    public boolean isMultipart(HttpServletRequest request) {
        return FileUploadBase.isMultipartContent((HttpServletRequest)request);
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        DiskFileUpload fileUpload = this.fileUpload;
        String enc = this.determineEncoding(request);
        if (!enc.equals(this.defaultEncoding)) {
            fileUpload = new DiskFileUpload();
            fileUpload.setSizeMax(this.fileUpload.getSizeMax());
            fileUpload.setSizeThreshold(this.fileUpload.getSizeThreshold());
            fileUpload.setRepositoryPath(this.fileUpload.getRepositoryPath());
            fileUpload.setHeaderEncoding(enc);
        }
        try {
            HashMap<String, CommonsMultipartFile> multipartFiles = new HashMap<String, CommonsMultipartFile>();
            HashMap<String, String[]> multipartParams = new HashMap<String, String[]>();
            List fileItems = fileUpload.parseRequest(request);
            Iterator it = fileItems.iterator();
            while (it.hasNext()) {
                FileItem fileItem = (FileItem)it.next();
                if (fileItem.isFormField()) {
                    String value = null;
                    try {
                        value = fileItem.getString(enc);
                    }
                    catch (UnsupportedEncodingException ex) {
                        this.logger.warn((Object)("Could not decode multipart item '" + fileItem.getFieldName() + "' with encoding '" + enc + "': using platform default"));
                        value = fileItem.getString();
                    }
                    String[] curParam = (String[])multipartParams.get(fileItem.getFieldName());
                    if (curParam == null) {
                        multipartParams.put(fileItem.getFieldName(), new String[]{value});
                        continue;
                    }
                    String[] newParam = StringUtils.addStringToArray(curParam, value);
                    multipartParams.put(fileItem.getFieldName(), newParam);
                    continue;
                }
                CommonsMultipartFile file = new CommonsMultipartFile(fileItem);
                multipartFiles.put(file.getName(), file);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Found multipart file [" + file.getName() + "] of size " + file.getSize() + " bytes with original filename [" + file.getOriginalFilename() + "], stored " + file.getStorageDescription()));
            }
            return new DefaultMultipartHttpServletRequest(request, multipartFiles, multipartParams);
        }
        catch (FileUploadBase.SizeLimitExceededException ex) {
            throw new MaxUploadSizeExceededException(this.fileUpload.getSizeMax(), (Throwable)ex);
        }
        catch (FileUploadException ex) {
            throw new MultipartException("Could not parse multipart request", ex);
        }
    }

    protected String determineEncoding(HttpServletRequest request) {
        String enc = request.getCharacterEncoding();
        if (enc == null) {
            enc = this.defaultEncoding;
        }
        return enc;
    }

    public void cleanupMultipart(MultipartHttpServletRequest request) {
        Map multipartFiles = request.getFileMap();
        Iterator it = multipartFiles.values().iterator();
        while (it.hasNext()) {
            CommonsMultipartFile file = (CommonsMultipartFile)it.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cleaning up multipart file [" + file.getName() + "] with original filename [" + file.getOriginalFilename() + "], stored " + file.getStorageDescription()));
            }
            file.getFileItem().delete();
        }
    }
}

