/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.servlet.mvc.AbstractUrlViewController;
import org.springframework.web.util.WebUtils;

public class UrlFilenameViewController
extends AbstractUrlViewController {
    private String prefix = "";
    private String suffix = "";
    private final Map viewNameCache = Collections.synchronizedMap(new HashMap());

    public void setPrefix(String prefix) {
        this.prefix = prefix != null ? prefix : "";
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix != null ? suffix : "";
    }

    protected String getSuffix() {
        return this.suffix;
    }

    protected String getViewNameForUrlPath(String urlPath) {
        String viewName = (String)this.viewNameCache.get(urlPath);
        if (viewName == null) {
            viewName = this.extractViewNameFromUrlPath(urlPath);
            viewName = this.postProcessViewName(viewName);
            this.viewNameCache.put(urlPath, viewName);
        }
        return viewName;
    }

    protected String extractViewNameFromUrlPath(String uri) {
        return WebUtils.extractFilenameFromUrlPath(uri);
    }

    protected String postProcessViewName(String viewName) {
        return this.getPrefix() + viewName + this.getSuffix();
    }
}

