/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.composer;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;
import org.switchyard.common.composer.MessageComposerInfo;
import org.switchyard.composer.MessageComposer;

public abstract class MessageComposerFactory<T> {
    private static final Logger LOGGER = Logger.getLogger(MessageComposerFactory.class);

    public abstract Class<T> getTargetClass();

    public abstract MessageComposer<T> newMessageComposerDefault();

    public final MessageComposer<T> newMessageComposer(MessageComposerInfo info) {
        MessageComposer<T> messageComposer = null;
        MessageComposerFactory<T> messageComposerFactory = MessageComposerFactory.getMessageComposerFactory(this.getTargetClass());
        messageComposer = info != null ? messageComposerFactory.newMessageComposer(info.getClazz()) : messageComposerFactory.newMessageComposerDefault();
        return messageComposer;
    }

    public final MessageComposer<T> newMessageComposer(Class<? extends MessageComposer<T>> custom) {
        MessageComposer<T> messageComposer = null;
        if (custom != null) {
            try {
                messageComposer = custom.newInstance();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Could not instantiate MessageComposer: " + custom.getClass().getName() + " - " + e.getMessage()));
            }
        }
        if (messageComposer == null) {
            messageComposer = this.newMessageComposerDefault();
        }
        return messageComposer;
    }

    public static final <F> MessageComposerFactory<F> getMessageComposerFactory(Class<F> targetClass) {
        return MessageComposerFactory.getMessageComposerFactories().get(targetClass);
    }

    public static final Map<Class, MessageComposerFactory> getMessageComposerFactories() {
        HashMap<Class, MessageComposerFactory> factories = new HashMap<Class, MessageComposerFactory>();
        ServiceLoader<MessageComposerFactory> services = ServiceLoader.load(MessageComposerFactory.class);
        for (MessageComposerFactory factory : services) {
            factories.put(factory.getTargetClass(), factory);
        }
        return factories;
    }
}

