/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.policy;

import java.util.HashSet;
import java.util.Set;
import org.switchyard.Exchange;
import org.switchyard.Property;
import org.switchyard.policy.Policy;

public final class ExchangePolicy {
    private static String PROVIDED_PROPERTY = "org.switchyard.policy.provided";
    private static String REQUIRED_PROPERTY = "org.switchyard.policy.required";

    private ExchangePolicy() {
    }

    public static void provide(Exchange exchange, Policy policy) {
        Set<Policy> provided = ExchangePolicy.getPolicies(exchange, PROVIDED_PROPERTY);
        provided.add(policy);
        exchange.getContext().setProperty(PROVIDED_PROPERTY, provided);
    }

    public static Set<Policy> getProvided(Exchange exchange) {
        return ExchangePolicy.getPolicies(exchange, PROVIDED_PROPERTY);
    }

    public static boolean isProvided(Exchange exchange, Policy policy) {
        return ExchangePolicy.containsPolicy(ExchangePolicy.getProvided(exchange), policy);
    }

    public static void require(Exchange exchange, Policy policy) {
        Set<Policy> required = ExchangePolicy.getPolicies(exchange, REQUIRED_PROPERTY);
        required.add(policy);
        exchange.getContext().setProperty(REQUIRED_PROPERTY, required);
    }

    public static Set<Policy> getRequired(Exchange exchange) {
        return ExchangePolicy.getPolicies(exchange, REQUIRED_PROPERTY);
    }

    public static boolean isRequired(Exchange exchange, Policy policy) {
        return ExchangePolicy.containsPolicy(ExchangePolicy.getRequired(exchange), policy);
    }

    private static Set<Policy> getPolicies(Exchange exchange, String propertyName) {
        Property intentsProperty = exchange.getContext().getProperty(propertyName);
        HashSet<Policy> intents = new HashSet<Policy>();
        if (intentsProperty != null) {
            intents.addAll((Set)intentsProperty.getValue());
        }
        return intents;
    }

    private static boolean containsPolicy(Set<Policy> list, Policy target) {
        boolean contains = false;
        for (Policy p : list) {
            if (!p.getName().equals(target.getName())) continue;
            contains = true;
            break;
        }
        return contains;
    }
}

