/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform;

import java.lang.reflect.ParameterizedType;
import javax.xml.namespace.QName;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.transform.Transformer;

public abstract class BaseTransformer<F, T>
implements Transformer<F, T> {
    private QName _from;
    private QName _to;

    public BaseTransformer() {
        this._to = JavaService.toMessageType(this.getType(Types.T));
        this._from = JavaService.toMessageType(this.getType(Types.F));
    }

    public BaseTransformer(QName from, QName to) {
        this._from = from;
        this._to = to;
    }

    @Override
    public Transformer<F, T> setFrom(QName fromType) {
        this._from = fromType;
        return this;
    }

    @Override
    public QName getFrom() {
        return this._from;
    }

    @Override
    public Transformer<F, T> setTo(QName toType) {
        this._to = toType;
        return this;
    }

    @Override
    public QName getTo() {
        return this._to;
    }

    @Override
    public Class<F> getFromType() {
        return this.getType(Types.F);
    }

    @Override
    public Class<T> getToType() {
        return this.getType(Types.T);
    }

    @Override
    public abstract T transform(F var1);

    protected static QName toMessageType(Class<?> type) {
        return JavaService.toMessageType(type);
    }

    private Class<?> getType(Types type) {
        try {
            ParameterizedType pt = (ParameterizedType)this.getClass().getGenericSuperclass();
            return (Class)pt.getActualTypeArguments()[type.ordinal()];
        }
        catch (Exception e) {
            return Object.class;
        }
    }

    private static enum Types {
        F,
        T;

    }
}

