/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import java.util.Arrays;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.internal.transform.BaseTransformerRegistry;
import org.switchyard.transform.TransformSequence;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;

public class TransformHandler
extends BaseHandler {
    private static Logger _logger = Logger.getLogger(TransformHandler.class);
    private TransformerRegistry _registry;

    public TransformHandler(TransformerRegistry registry) {
        this._registry = registry;
    }

    public TransformHandler(Transformer<?, ?> ... transforms) {
        if (transforms != null && transforms.length > 0) {
            this._registry = new BaseTransformerRegistry(new HashSet(Arrays.asList(transforms)));
        }
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        TransformSequence.applySequence((Exchange)exchange, (TransformerRegistry)this._registry);
        if (!TransformSequence.assertTransformsApplied((Exchange)exchange)) {
            QName actualPayloadType = TransformSequence.getCurrentMessageType((Exchange)exchange);
            QName expectedPayloadType = TransformSequence.getTargetMessageType((Exchange)exchange);
            throw new HandlerException("Transformations not applied.  Required payload type of '" + expectedPayloadType + "'.  Actual payload type is '" + actualPayloadType + "'.  You must define and register a Transformer to transform between these types.");
        }
    }

    public void handleFault(Exchange exchange) {
        TransformSequence.applySequence((Exchange)exchange, (TransformerRegistry)this._registry);
        if (!TransformSequence.assertTransformsApplied((Exchange)exchange)) {
            QName actualPayloadType = TransformSequence.getCurrentMessageType((Exchange)exchange);
            QName expectedPayloadType = TransformSequence.getTargetMessageType((Exchange)exchange);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Transformations not applied.  Required payload type of '" + expectedPayloadType + "'.  Actual payload type is '" + actualPayloadType + "'.  You must define and register a Transformer to transform between these types."));
            }
        }
    }
}

