/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.io.graph;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.switchyard.internal.io.graph.Graph;
import org.switchyard.internal.io.graph.GraphBuilder;

public class CollectionGraph<T>
implements Graph<Collection<T>> {
    private LinkedList<Graph<T>> _collection;

    public LinkedList<Graph<T>> getCollection() {
        return this._collection;
    }

    public void setCollection(LinkedList<Graph<T>> collection) {
        this._collection = collection;
    }

    @Override
    public void compose(Collection<T> object, Map<Integer, Object> visited) throws IOException {
        this._collection = new LinkedList();
        for (T o : object) {
            this._collection.add(GraphBuilder.build(o, visited));
        }
    }

    @Override
    public Collection<T> decompose(Map<Integer, Object> visited) throws IOException {
        LinkedList<Graph<T>> gc = this.getCollection();
        if (gc != null) {
            LinkedList oc = new LinkedList();
            for (Graph graph : gc) {
                oc.add(graph.decompose(visited));
            }
            return oc;
        }
        return null;
    }

    public String toString() {
        return "CollectionGraph(collection=" + this.getCollection() + ")";
    }
}

