/*
 * Copyright 2021 TiKV Project Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.tikv.common.expression;

import static com.google.common.base.Preconditions.checkNotNull;

import java.io.Serializable;
import org.tikv.common.expression.visitor.ProtoConverter;

public class ByItem implements Serializable {
  private final Expression expr;
  private final boolean desc;

  private ByItem(Expression expr, boolean desc) {
    checkNotNull(expr, "Expr cannot be null for ByItem");

    this.expr = expr;
    this.desc = desc;
  }

  public static ByItem create(Expression expr, boolean desc) {
    return new ByItem(expr, desc);
  }

  public com.pingcap.tidb.tipb.ByItem toProto(Object context) {
    com.pingcap.tidb.tipb.ByItem.Builder builder = com.pingcap.tidb.tipb.ByItem.newBuilder();
    return builder.setExpr(ProtoConverter.toProto(expr, context)).setDesc(desc).build();
  }

  public Expression getExpr() {
    return expr;
  }

  public boolean isDesc() {
    return desc;
  }

  @Override
  public String toString() {
    return String.format("[%s %s]", expr.toString(), desc ? "DESC" : "ASC");
  }
}
