/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common;

import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tikv.shade.com.google.common.collect.ImmutableMap;

public class Utils {
    private static final ImmutableMap<String, TimeUnit> timeSuffixes = ImmutableMap.builder().put("us", TimeUnit.MICROSECONDS).put("ms", TimeUnit.MILLISECONDS).put("s", TimeUnit.SECONDS).put("m", TimeUnit.MINUTES).put("min", TimeUnit.MINUTES).put("h", TimeUnit.HOURS).put("d", TimeUnit.DAYS).build();

    public static ConcurrentHashMap<String, String> getSystemProperties() {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        System.getProperties().stringPropertyNames().forEach(key -> map.put((String)key, System.getProperty(key)));
        return map;
    }

    public static void setSystemProperties(ConcurrentHashMap<String, String> settings) {
        Properties prop = new Properties();
        settings.forEach(prop::setProperty);
        System.setProperties(prop);
    }

    public static long timeStringAs(String str, TimeUnit unit) {
        String lower = str.toLowerCase(Locale.ROOT).trim();
        try {
            Matcher m = Pattern.compile("(-?[0-9]+)([a-z]+)?").matcher(lower);
            if (!m.matches()) {
                throw new NumberFormatException("Failed to parse time string: " + str);
            }
            long val = Long.parseLong(m.group(1));
            String suffix = m.group(2);
            if (suffix != null && !timeSuffixes.containsKey(suffix)) {
                throw new NumberFormatException("Invalid suffix: \"" + suffix + "\"");
            }
            return unit.convert(val, suffix != null ? timeSuffixes.get(suffix) : unit);
        }
        catch (NumberFormatException e) {
            String timeError = "Time must be specified as seconds (s), milliseconds (ms), microseconds (us), minutes (m or min), hour (h), or day (d). E.g. 50s, 100ms, or 250us.";
            throw new NumberFormatException(timeError + "\n" + e.getMessage());
        }
    }

    public static long timeStringAsMs(String str) {
        return Utils.timeStringAs(str, TimeUnit.MILLISECONDS);
    }

    public static long timeStringAsSec(String str) {
        return Utils.timeStringAs(str, TimeUnit.SECONDS);
    }
}

