/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.apiversion;

import org.tikv.common.apiversion.CodecUtils;
import org.tikv.common.apiversion.RequestKeyCodec;
import org.tikv.common.util.Pair;
import org.tikv.kvproto.Metapb;
import org.tikv.shade.com.google.protobuf.ByteString;

public class RequestKeyV2Codec
implements RequestKeyCodec {
    protected static final ByteString RAW_DEFAULT_PREFIX = ByteString.copyFrom(new byte[]{114, 0, 0, 0});
    protected static final ByteString RAW_DEFAULT_END = ByteString.copyFrom(new byte[]{114, 0, 0, 1});
    protected static final ByteString TXN_DEFAULT_PREFIX = ByteString.copyFrom(new byte[]{120, 0, 0, 0});
    protected static final ByteString TXN_DEFAULT_END = ByteString.copyFrom(new byte[]{120, 0, 0, 1});
    protected ByteString keyPrefix;
    protected ByteString infiniteEndKey;

    @Override
    public ByteString encodeKey(ByteString key) {
        return this.keyPrefix.concat(key);
    }

    @Override
    public ByteString decodeKey(ByteString key) {
        if (key.isEmpty()) {
            return key;
        }
        if (!key.startsWith(this.keyPrefix)) {
            throw new IllegalArgumentException("key corrupted, wrong prefix");
        }
        return key.substring(this.keyPrefix.size());
    }

    @Override
    public Pair<ByteString, ByteString> encodeRange(ByteString start, ByteString end) {
        start = this.encodeKey(start);
        end = end.isEmpty() ? this.infiniteEndKey : this.encodeKey(end);
        return Pair.create(start, end);
    }

    @Override
    public ByteString encodePdQuery(ByteString key) {
        return CodecUtils.encode(this.encodeKey(key));
    }

    @Override
    public Pair<ByteString, ByteString> encodePdQueryRange(ByteString start, ByteString end) {
        Pair<ByteString, ByteString> range = this.encodeRange(start, end);
        return Pair.create(CodecUtils.encode((ByteString)range.first), CodecUtils.encode((ByteString)range.second));
    }

    @Override
    public Metapb.Region decodeRegion(Metapb.Region region) {
        Metapb.Region.Builder builder = Metapb.Region.newBuilder().mergeFrom(region);
        ByteString start = region.getStartKey();
        ByteString end = region.getEndKey();
        if (!start.isEmpty()) {
            start = CodecUtils.decode(start);
            start = ByteString.unsignedLexicographicalComparator().compare(start, this.keyPrefix) < 0 ? ByteString.EMPTY : this.decodeKey(start);
        }
        if (!end.isEmpty()) {
            end = CodecUtils.decode(end);
            end = ByteString.unsignedLexicographicalComparator().compare(end, this.infiniteEndKey) >= 0 ? ByteString.EMPTY : this.decodeKey(end);
        }
        return builder.setStartKey(start).setEndKey(end).build();
    }
}

