/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.expression.visitor;

import com.pingcap.tidb.tipb.Expr;
import com.pingcap.tidb.tipb.ExprType;
import com.pingcap.tidb.tipb.FieldType;
import com.pingcap.tidb.tipb.ScalarFuncSig;
import java.util.Map;
import java.util.Objects;
import org.tikv.common.codec.Codec;
import org.tikv.common.codec.CodecDataOutput;
import org.tikv.common.exception.TiExpressionException;
import org.tikv.common.expression.AggregateFunction;
import org.tikv.common.expression.ArithmeticBinaryExpression;
import org.tikv.common.expression.ColumnRef;
import org.tikv.common.expression.ComparisonBinaryExpression;
import org.tikv.common.expression.Constant;
import org.tikv.common.expression.Expression;
import org.tikv.common.expression.FuncCallExpr;
import org.tikv.common.expression.IsNull;
import org.tikv.common.expression.LogicalBinaryExpression;
import org.tikv.common.expression.Not;
import org.tikv.common.expression.StringRegExpression;
import org.tikv.common.expression.Visitor;
import org.tikv.common.types.BitType;
import org.tikv.common.types.BytesType;
import org.tikv.common.types.DataType;
import org.tikv.common.types.DateTimeType;
import org.tikv.common.types.DateType;
import org.tikv.common.types.DecimalType;
import org.tikv.common.types.IntegerType;
import org.tikv.common.types.RealType;
import org.tikv.common.types.StringType;
import org.tikv.common.types.TimeType;
import org.tikv.common.types.TimestampType;
import org.tikv.shade.com.google.common.collect.ImmutableMap;

public class ProtoConverter
extends Visitor<Expr, Object> {
    private static final Map<Class<? extends DataType>, String> SCALAR_SIG_MAP = ImmutableMap.builder().put(IntegerType.class, "Int").put(BitType.class, "Int").put(DecimalType.class, "Decimal").put(RealType.class, "Real").put(DateTimeType.class, "Time").put(DateType.class, "Time").put(TimestampType.class, "Time").put(BytesType.class, "String").put(StringType.class, "String").put(TimeType.class, "Duration").build();
    private final boolean validateColPosition;

    public ProtoConverter() {
        this(true);
    }

    public ProtoConverter(boolean validateColPosition) {
        this.validateColPosition = validateColPosition;
    }

    public static Expr toProto(Expression expression) {
        return ProtoConverter.toProto(expression, null);
    }

    public static Expr toProto(Expression expression, Object context) {
        ProtoConverter converter = new ProtoConverter();
        return expression.accept(converter, context);
    }

    private DataType getType(Expression expression) {
        DataType type = expression.getDataType();
        if (type == null) {
            throw new TiExpressionException(String.format("Expression %s type unknown", expression));
        }
        if (type instanceof TimestampType) {
            return DateTimeType.DATETIME;
        }
        return type;
    }

    private String getTypeSignature(Expression expression) {
        DataType type = this.getType(expression);
        String typeSignature = SCALAR_SIG_MAP.get(type.getClass());
        if (typeSignature == null) {
            throw new TiExpressionException(String.format("Type %s signature unknown", type));
        }
        return typeSignature;
    }

    private FieldType toPBFieldType(DataType fieldType) {
        return FieldType.newBuilder().setTp(fieldType.getTypeCode()).setFlag(fieldType.getFlag()).setFlen((int)fieldType.getLength()).setDecimal(fieldType.getDecimal()).setCharset(fieldType.getCharset()).setCollate(fieldType.getCollationCode()).build();
    }

    private Expr.Builder scalarToPartialProto(Expression node, Object context) {
        Expr.Builder builder = Expr.newBuilder();
        builder.setTp(ExprType.ScalarFunc);
        builder.setFieldType(this.toPBFieldType(this.getType(node)));
        for (Expression child : node.getChildren()) {
            Expr exprProto = child.accept(this, context);
            builder.addChildren(exprProto);
        }
        return builder;
    }

    @Override
    protected Expr visit(LogicalBinaryExpression node, Object context) {
        ScalarFuncSig protoSig;
        switch (node.getCompType()) {
            case AND: {
                protoSig = ScalarFuncSig.LogicalAnd;
                break;
            }
            case OR: {
                protoSig = ScalarFuncSig.LogicalOr;
                break;
            }
            case XOR: {
                protoSig = ScalarFuncSig.LogicalXor;
                break;
            }
            default: {
                throw new TiExpressionException(String.format("Unknown comparison type %s", new Object[]{node.getCompType()}));
            }
        }
        Expr.Builder builder = this.scalarToPartialProto(node, context);
        builder.setSig(protoSig);
        builder.setFieldType(this.toPBFieldType(this.getType(node)));
        return builder.build();
    }

    @Override
    protected Expr visit(ArithmeticBinaryExpression node, Object context) {
        ScalarFuncSig protoSig;
        Expression child = node.getLeft();
        String typeSignature = this.getTypeSignature(child);
        switch (node.getCompType()) {
            case BIT_AND: {
                protoSig = ScalarFuncSig.BitAndSig;
                break;
            }
            case BIT_OR: {
                protoSig = ScalarFuncSig.BitOrSig;
                break;
            }
            case BIT_XOR: {
                protoSig = ScalarFuncSig.BitXorSig;
                break;
            }
            case DIVIDE: {
                protoSig = ScalarFuncSig.valueOf("Divide" + typeSignature);
                break;
            }
            case MINUS: {
                protoSig = ScalarFuncSig.valueOf("Minus" + typeSignature);
                break;
            }
            case MULTIPLY: {
                protoSig = ScalarFuncSig.valueOf("Multiply" + typeSignature);
                break;
            }
            case PLUS: {
                protoSig = ScalarFuncSig.valueOf("Plus" + typeSignature);
                break;
            }
            default: {
                throw new TiExpressionException(String.format("Unknown comparison type %s", new Object[]{node.getCompType()}));
            }
        }
        Expr.Builder builder = this.scalarToPartialProto(node, context);
        builder.setSig(protoSig);
        builder.setFieldType(this.toPBFieldType(this.getType(node)));
        return builder.build();
    }

    @Override
    protected Expr visit(ComparisonBinaryExpression node, Object context) {
        ScalarFuncSig protoSig;
        ComparisonBinaryExpression.NormalizedPredicate predicate = node.normalize();
        if (predicate.getValue().isOverflowed()) {
            throw new UnsupportedOperationException("overflowed ComparisonBinaryExpression cannot be pushed down");
        }
        Expression child = node.getLeft();
        String typeSignature = this.getTypeSignature(child);
        switch (node.getComparisonType()) {
            case EQUAL: {
                protoSig = ScalarFuncSig.valueOf("EQ" + typeSignature);
                break;
            }
            case GREATER_EQUAL: {
                protoSig = ScalarFuncSig.valueOf("GE" + typeSignature);
                break;
            }
            case GREATER_THAN: {
                protoSig = ScalarFuncSig.valueOf("GT" + typeSignature);
                break;
            }
            case LESS_EQUAL: {
                protoSig = ScalarFuncSig.valueOf("LE" + typeSignature);
                break;
            }
            case LESS_THAN: {
                protoSig = ScalarFuncSig.valueOf("LT" + typeSignature);
                break;
            }
            case NOT_EQUAL: {
                protoSig = ScalarFuncSig.valueOf("NE" + typeSignature);
                break;
            }
            default: {
                throw new TiExpressionException(String.format("Unknown comparison type %s", new Object[]{node.getComparisonType()}));
            }
        }
        Expr.Builder builder = this.scalarToPartialProto(node, context);
        builder.setSig(protoSig);
        builder.setFieldType(this.toPBFieldType(this.getType(node)));
        return builder.build();
    }

    @Override
    protected Expr visit(StringRegExpression node, Object context) {
        ScalarFuncSig protoSig;
        switch (node.getRegType()) {
            case STARTS_WITH: 
            case CONTAINS: 
            case ENDS_WITH: 
            case LIKE: {
                protoSig = ScalarFuncSig.LikeSig;
                break;
            }
            default: {
                throw new TiExpressionException(String.format("Unknown reg type %s", new Object[]{node.getRegType()}));
            }
        }
        Expr.Builder builder = this.scalarToPartialProto(node, context);
        builder.setSig(protoSig);
        return builder.build();
    }

    @Override
    protected Expr visit(ColumnRef node, Object context) {
        long position = 0L;
        if (this.validateColPosition) {
            Objects.requireNonNull(context, "Context of a ColumnRef should not be null");
            Map colIdOffsetMap = (Map)context;
            position = Objects.requireNonNull((Integer)colIdOffsetMap.get(node.getName()), "Required column position info " + node.getName() + " is not in a valid context.").intValue();
        }
        Expr.Builder builder = Expr.newBuilder();
        builder.setTp(ExprType.ColumnRef);
        CodecDataOutput cdo = new CodecDataOutput();
        Codec.IntegerCodec.writeLong(cdo, position);
        builder.setVal(cdo.toByteString());
        builder.setFieldType(this.toPBFieldType(this.getType(node)));
        return builder.build();
    }

    @Override
    protected Expr visit(Constant node, Object context) {
        Expr.Builder builder = Expr.newBuilder();
        DataType type = node.getDataType();
        if (node.getValue() == null) {
            builder.setTp(ExprType.Null);
        } else {
            if (node.isOverflowed()) {
                throw new UnsupportedOperationException("overflowed value cannot be pushed down to coprocessor");
            }
            builder.setTp(type.getProtoExprType());
            CodecDataOutput cdo = new CodecDataOutput();
            type.encode(cdo, DataType.EncodeType.PROTO, node.getValue());
            builder.setVal(cdo.toByteString());
            builder.setFieldType(this.toPBFieldType(this.getType(node)));
        }
        return builder.build();
    }

    @Override
    protected Expr visit(AggregateFunction node, Object context) {
        Expr.Builder builder = Expr.newBuilder();
        AggregateFunction.FunctionType type = node.getType();
        switch (type) {
            case Max: {
                builder.setTp(ExprType.Max);
                break;
            }
            case Sum: {
                builder.setTp(ExprType.Sum);
                break;
            }
            case Min: {
                builder.setTp(ExprType.Min);
                break;
            }
            case First: {
                builder.setTp(ExprType.First);
                break;
            }
            case Count: {
                builder.setTp(ExprType.Count);
            }
        }
        for (Expression arg : node.getChildren()) {
            Expr exprProto = arg.accept(this, context);
            builder.addChildren(exprProto);
        }
        builder.setFieldType(this.toPBFieldType(this.getType(node)));
        return builder.build();
    }

    @Override
    protected Expr visit(IsNull node, Object context) {
        String typeSignature = this.getTypeSignature(node.getExpression());
        ScalarFuncSig protoSig = ScalarFuncSig.valueOf(typeSignature + "IsNull");
        Expr.Builder builder = this.scalarToPartialProto(node, context);
        builder.setSig(protoSig);
        builder.setFieldType(this.toPBFieldType(this.getType(node)));
        return builder.build();
    }

    @Override
    protected Expr visit(Not node, Object context) {
        ScalarFuncSig protoSig = null;
        DataType dataType = this.getType(node);
        switch (dataType.getType()) {
            case TypeDecimal: {
                protoSig = ScalarFuncSig.UnaryNotDecimal;
                break;
            }
            case TypeDouble: 
            case TypeFloat: {
                protoSig = ScalarFuncSig.UnaryNotReal;
                break;
            }
            case TypeInt24: 
            case TypeLong: 
            case TypeShort: 
            case TypeLonglong: 
            case TypeTiny: {
                protoSig = ScalarFuncSig.UnaryNotInt;
                break;
            }
        }
        Objects.requireNonNull(protoSig, "unary not can not find proper proto signature.");
        Expr.Builder builder = this.scalarToPartialProto(node, context);
        builder.setSig(protoSig);
        builder.setFieldType(this.toPBFieldType(this.getType(node)));
        return builder.build();
    }

    @Override
    protected Expr visit(FuncCallExpr node, Object context) {
        ScalarFuncSig protoSig = ScalarFuncSig.Year;
        Expr.Builder builder = this.scalarToPartialProto(node, context);
        builder.setSig(protoSig);
        builder.setFieldType(this.toPBFieldType(this.getType(node)));
        return builder.build();
    }
}

