/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.importer;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.tikv.common.PDClient;
import org.tikv.common.importer.ImporterStoreClient;
import org.tikv.common.region.TiStore;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.kvproto.ImportSstpb;
import org.tikv.kvproto.Metapb;
import org.tikv.shade.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class SwitchTiKVModeClient {
    private static final int IMPORT_MODE_TIMEOUT = 600;
    private static final int KEEP_TIKV_TO_IMPORT_MODE_PERIOD = 120;
    private final PDClient pdClient;
    private final ImporterStoreClient.ImporterStoreClientBuilder builder;
    private ScheduledExecutorService ingestScheduledExecutorService;

    public SwitchTiKVModeClient(PDClient pdClient, ImporterStoreClient.ImporterStoreClientBuilder builder) {
        this.pdClient = pdClient;
        this.builder = builder;
    }

    public void switchTiKVToNormalMode() {
        this.doSwitchTiKVMode(ImportSstpb.SwitchMode.Normal);
    }

    public synchronized void keepTiKVToImportMode() {
        if (this.ingestScheduledExecutorService == null) {
            this.ingestScheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("switch-tikv-mode-pool-%d").setDaemon(true).build());
            this.ingestScheduledExecutorService.scheduleAtFixedRate(this::switchTiKVToImportMode, 0L, 120L, TimeUnit.SECONDS);
        }
    }

    public synchronized void stopKeepTiKVToImportMode() {
        if (this.ingestScheduledExecutorService != null) {
            this.ingestScheduledExecutorService.shutdown();
            this.ingestScheduledExecutorService = null;
        }
    }

    private void switchTiKVToImportMode() {
        this.doSwitchTiKVMode(ImportSstpb.SwitchMode.Import);
    }

    private void doSwitchTiKVMode(ImportSstpb.SwitchMode mode) {
        ConcreteBackOffer bo = ConcreteBackOffer.newCustomBackOff(5000, this.pdClient.getClusterId());
        List<Metapb.Store> allStores = this.pdClient.getAllStores(bo);
        for (Metapb.Store store : allStores) {
            ImporterStoreClient client = this.builder.build(new TiStore(store));
            client.switchMode(mode);
        }
    }
}

