/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.region;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.ReadOnlyPDClient;
import org.tikv.common.region.RegionCache;
import org.tikv.common.region.TiStore;
import org.tikv.common.util.ChannelFactory;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.kvproto.Metapb;
import org.tikv.shade.io.grpc.ManagedChannel;
import org.tikv.shade.io.grpc.health.v1.HealthCheckRequest;
import org.tikv.shade.io.grpc.health.v1.HealthCheckResponse;
import org.tikv.shade.io.grpc.health.v1.HealthGrpc;

public class StoreHealthyChecker
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(StoreHealthyChecker.class);
    private static final long MAX_CHECK_STORE_TOMBSTONE_TICK = 60L;
    private final BlockingQueue<TiStore> taskQueue = new LinkedBlockingQueue<TiStore>();
    private final ChannelFactory channelFactory;
    private final ReadOnlyPDClient pdClient;
    private final RegionCache cache;
    private long checkTombstoneTick;
    private final long timeout;

    public StoreHealthyChecker(ChannelFactory channelFactory, ReadOnlyPDClient pdClient, RegionCache cache, long timeout) {
        this.channelFactory = channelFactory;
        this.pdClient = pdClient;
        this.cache = cache;
        this.checkTombstoneTick = 0L;
        this.timeout = timeout;
    }

    public boolean scheduleStoreHealthCheck(TiStore store) {
        return this.taskQueue.add(store);
    }

    private List<TiStore> getValidStores() {
        LinkedList<TiStore> unhealthStore = new LinkedList<TiStore>();
        while (!this.taskQueue.isEmpty()) {
            try {
                TiStore store = this.taskQueue.take();
                if (!store.isValid()) continue;
                unhealthStore.add(store);
            }
            catch (Exception e) {
                return unhealthStore;
            }
        }
        return unhealthStore;
    }

    private boolean checkStoreHealth(TiStore store) {
        String addressStr = store.getStore().getAddress();
        try {
            ManagedChannel channel = this.channelFactory.getChannel(addressStr, this.pdClient.getHostMapping());
            HealthGrpc.HealthBlockingStub stub = (HealthGrpc.HealthBlockingStub)HealthGrpc.newBlockingStub(channel).withDeadlineAfter(this.timeout, TimeUnit.MILLISECONDS);
            HealthCheckRequest req = HealthCheckRequest.newBuilder().build();
            HealthCheckResponse resp = stub.check(req);
            return resp.getStatus() == HealthCheckResponse.ServingStatus.SERVING;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkStoreTombstone(TiStore store) {
        try {
            Metapb.Store newStore = this.pdClient.getStore(ConcreteBackOffer.newRawKVBackOff(this.pdClient.getClusterId()), store.getId());
            if (newStore != null && newStore.getState() == Metapb.StoreState.Tombstone) {
                return true;
            }
        }
        catch (Exception e) {
            logger.info("fail to check tombstone stores", (Throwable)e);
            return false;
        }
        return false;
    }

    @Override
    public void run() {
        ++this.checkTombstoneTick;
        boolean needCheckTombstoneStore = false;
        if (this.checkTombstoneTick >= 60L) {
            needCheckTombstoneStore = true;
            this.checkTombstoneTick = 0L;
        }
        List<TiStore> allStores = this.getValidStores();
        LinkedList<TiStore> unreachableStore = new LinkedList<TiStore>();
        for (TiStore store : allStores) {
            block11: {
                block9: {
                    block10: {
                        if (needCheckTombstoneStore && this.checkStoreTombstone(store)) continue;
                        if (!this.checkStoreHealth(store)) break block9;
                        if (store.getProxyStore() == null) break block10;
                        TiStore newStore = store.withProxy(null);
                        logger.warn(String.format("store [%s] recovers to be reachable", store.getAddress()));
                        if (this.cache.putStore(newStore.getId(), newStore)) {
                            this.taskQueue.add(newStore);
                            continue;
                        }
                        break block11;
                    }
                    if (store.isReachable()) break block11;
                    logger.warn(String.format("store [%s] recovers to be reachable", store.getAddress()));
                    store.markReachable();
                    break block11;
                }
                if (store.isReachable()) {
                    unreachableStore.add(store);
                    continue;
                }
            }
            this.taskQueue.add(store);
        }
        if (!unreachableStore.isEmpty()) {
            try {
                Thread.sleep(this.timeout);
            }
            catch (Exception e) {
                this.taskQueue.addAll(unreachableStore);
                return;
            }
            for (TiStore store : unreachableStore) {
                if (!this.checkStoreHealth(store)) {
                    logger.warn(String.format("store [%s] is not reachable", store.getAddress()));
                    store.markUnreachable();
                }
                this.taskQueue.add(store);
            }
        }
    }
}

