/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.replica;

import java.util.List;
import org.tikv.kvproto.Metapb;
import org.tikv.shade.com.google.common.base.MoreObjects;

public class Store {
    private static final Label[] EMPTY_LABELS = new Label[0];
    private Label[] labels;
    private final Metapb.Peer peer;
    private final Metapb.Store store;
    private final boolean isLeader;

    Store(Metapb.Peer peer, Metapb.Store store, boolean isLeader) {
        this.peer = peer;
        this.store = store;
        this.isLeader = isLeader;
    }

    public Metapb.Peer getPeer() {
        return this.peer;
    }

    public Label[] getLabels() {
        if (this.labels == null) {
            List<Metapb.StoreLabel> labelList = this.store.getLabelsList();
            this.labels = labelList.isEmpty() ? EMPTY_LABELS : (Label[])labelList.stream().map(Label::new).toArray(Label[]::new);
        }
        return this.labels;
    }

    public boolean isLearner() {
        return this.peer.getRole() == Metapb.PeerRole.Learner;
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public boolean isFollower() {
        return this.peer.getRole() == Metapb.PeerRole.Voter && !this.isLeader;
    }

    public long getId() {
        return this.store.getId();
    }

    public String getAddress() {
        return this.store.getAddress();
    }

    public String getVersion() {
        return this.store.getVersion();
    }

    public State getState() {
        switch (this.store.getState()) {
            case Up: {
                return State.Up;
            }
            case Offline: {
                return State.Offline;
            }
            case Tombstone: {
                return State.Tombstone;
            }
        }
        return State.Unknown;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Store)) {
            return false;
        }
        Store other = (Store)o;
        return this.peer.equals(other.peer);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("peer", this.peer).add("store", this.store).toString();
    }

    public static enum State {
        Unknown,
        Up,
        Offline,
        Tombstone;

    }

    public static class Label {
        private final Metapb.StoreLabel label;

        Label(Metapb.StoreLabel label) {
            this.label = label;
        }

        public String getKey() {
            return this.label.getKey();
        }

        public String getValue() {
            return this.label.getValue();
        }
    }
}

