/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.txn;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.TiSession;
import org.tikv.common.codec.KeyUtils;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.exception.TiBatchWriteException;
import org.tikv.common.meta.TiTimestamp;
import org.tikv.common.region.RegionManager;
import org.tikv.common.region.TiRegion;
import org.tikv.common.region.TiStore;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.common.util.Pair;
import org.tikv.shade.com.google.protobuf.ByteString;
import org.tikv.txn.TxnKVClient;
import org.tikv.txn.type.ClientRPCResult;

public class TTLManager {
    public static final int MANAGED_LOCK_TTL = 20000;
    private static final Logger LOG = LoggerFactory.getLogger(TTLManager.class);
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_CLOSED = 2;
    private static final int SCHEDULER_PERIOD = 10000;
    private static final int SCHEDULER_INITIAL_DELAY = 5000;
    private final long startTS;
    private final ByteString primaryLock;
    private final TxnKVClient kvClient;
    private final RegionManager regionManager;
    private final ScheduledExecutorService scheduler;
    private final AtomicInteger state;

    public TTLManager(TiSession session, long startTS, byte[] primaryKey) {
        this.startTS = startTS;
        this.primaryLock = ByteString.copyFrom(primaryKey);
        this.state = new AtomicInteger(0);
        this.kvClient = session.createTxnClient();
        this.regionManager = this.kvClient.getRegionManager();
        this.scheduler = new ScheduledThreadPoolExecutor(1, new BasicThreadFactory.Builder().namingPattern("ttl-manager-pool-%d").daemon(false).build());
    }

    public void keepAlive() {
        if (this.state.compareAndSet(0, 1)) {
            this.scheduler.scheduleAtFixedRate(this::doKeepAlive, 5000L, 10000L, TimeUnit.MILLISECONDS);
        } else {
            LOG.warn("keepAlive failed state={} key={}", (Object)this.state.get(), (Object)KeyUtils.formatBytes(this.primaryLock));
        }
    }

    private void doKeepAlive() {
        ConcreteBackOffer bo = ConcreteBackOffer.newCustomBackOff(20000, this.regionManager.getPDClient().getClusterId());
        long uptime = this.kvClient.getTimestamp().getPhysical() - TiTimestamp.extractPhysical(this.startTS);
        long ttl = uptime + 20000L;
        LOG.info("doKeepAlive key={} uptime={} ttl={}", new Object[]{KeyUtils.formatBytes(this.primaryLock), uptime, ttl});
        try {
            this.sendTxnHeartBeat(bo, ttl);
            LOG.info("doKeepAlive success");
        }
        catch (Exception e) {
            LOG.warn("doKeepAlive error", (Throwable)e);
        }
    }

    private void sendTxnHeartBeat(BackOffer bo, long ttl) {
        Pair<TiRegion, TiStore> pair = this.regionManager.getRegionStorePairByKey(this.primaryLock);
        TiRegion tiRegion = (TiRegion)pair.first;
        TiStore store = (TiStore)pair.second;
        ClientRPCResult result = this.kvClient.txnHeartBeat(bo, this.primaryLock, this.startTS, ttl, tiRegion, store);
        if (!result.isSuccess() && !result.isRetry()) {
            throw new TiBatchWriteException("sendTxnHeartBeat error", result.getException());
        }
        if (result.isRetry()) {
            try {
                bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new GrpcException(String.format("sendTxnHeartBeat failed, regionId=%s", tiRegion.getId()), result.getException()));
                this.regionManager.invalidateStore(store.getStore().getId());
                this.regionManager.invalidateRegion(tiRegion);
                this.sendTxnHeartBeat(bo, ttl);
            }
            catch (GrpcException e) {
                String errorMsg = String.format("sendTxnHeartBeat error, regionId=%s, detail=%s", tiRegion.getId(), e.getMessage());
                throw new TiBatchWriteException(errorMsg, e);
            }
        }
        LOG.debug("sendTxnHeartBeat success key={} ttl={} success", (Object)KeyUtils.formatBytes(this.primaryLock), (Object)ttl);
    }

    public void close() throws InterruptedException {
        if (this.state.compareAndSet(1, 2)) {
            this.scheduler.shutdown();
        }
    }
}

