/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.colors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.factory.colors.ColorSpaceFactory;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDSpecialColorSpace;
import org.verapdf.pd.function.PDFunction;

public class PDDeviceN
extends PDSpecialColorSpace {
    private final List<COSObject> names;

    public PDDeviceN(COSObject obj) {
        this(obj, null, false);
    }

    public PDDeviceN(COSObject obj, PDResources resources, boolean wasDefault) {
        super(obj, resources, wasDefault);
        this.names = PDDeviceN.parseNames(obj.at(1));
    }

    public List<COSObject> getNames() {
        return this.names;
    }

    public PDColorSpace getAlternateSpace() {
        return super.getBaseColorSpace();
    }

    public List<PDColorSpace> getColorants() {
        COSObject colorantsDict;
        LinkedList<PDColorSpace> colorants = new LinkedList<PDColorSpace>();
        COSObject attributes = this.getAttributes();
        if (attributes != null && attributes.getType() == COSObjType.COS_DICT && (colorantsDict = attributes.getKey(ASAtom.COLORANTS)).getType() == COSObjType.COS_DICT) {
            for (COSObject value : colorantsDict.getValues()) {
                colorants.add(ColorSpaceFactory.getColorSpace(value, this.getResources()));
            }
        }
        return colorants;
    }

    @Override
    protected COSObject getBaseColorSpaceObject() {
        return this.getObject().at(2);
    }

    public COSObject getCosTintTransform() {
        return this.getObject().at(3);
    }

    public PDFunction getTintTransform() {
        return PDFunction.createFunction(this.getCosTintTransform());
    }

    public COSObject getAttributes() {
        return this.getObject().at(4);
    }

    @Override
    public int getNumberOfComponents() {
        return this.names.size();
    }

    @Override
    public ASAtom getType() {
        return ASAtom.DEVICEN;
    }

    private static List<COSObject> parseNames(COSObject obj) {
        if (obj != null && obj.getType() == COSObjType.COS_ARRAY) {
            ArrayList<COSObject> names = new ArrayList<COSObject>(obj.size());
            for (int i = 0; i < obj.size(); ++i) {
                names.add(obj.at(i));
            }
            return Collections.unmodifiableList(names);
        }
        return Collections.emptyList();
    }

    @Override
    public double[] toRGB(double[] value) {
        double[] altValue = this.getDoubleArrayResult(value, this.getTintTransform());
        return this.getAlternateSpace().toRGB(altValue);
    }
}

