/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.guice;

import com.google.inject.multibindings.Multibinder;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.com.google.common.base.Throwables;
import org.weakref.jmx.guice.MapExportBinder;
import org.weakref.jmx.guice.MapMapping;
import org.weakref.jmx.guice.ObjectNameFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringMapExportBinder<V>
extends MapExportBinder<String, V> {
    private final Class<V> valueClass;

    StringMapExportBinder(Multibinder<MapMapping<?, ?>> binder, Class<V> valueClass) {
        super(binder, String.class, valueClass);
        this.valueClass = valueClass;
    }

    public void withGeneratedName() {
        ObjectNameFunction namingFunction = new ObjectNameFunction<Map.Entry<String, V>>(){

            @Override
            public ObjectName name(Map.Entry<String, V> entry) {
                try {
                    return new ObjectName(ObjectNames.generatedNameOf(StringMapExportBinder.this.valueClass, entry.getKey()));
                }
                catch (MalformedObjectNameException e) {
                    throw Throwables.propagate(e);
                }
            }
        };
        this.binder.addBinding().toInstance(new MapMapping<String, V>(String.class, this.valueClass, namingFunction));
    }
}

