/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class SecurePasswordInputPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String BACKSPACE = "\u21e6";
    private static final String CAPS = "\u21e7";
    private static final String CLEAR = "Clear";
    private static final String OK = "OK";
    private static final Map<Integer, String[]> KEYS_MAP = new HashMap<Integer, String[]>();
    private final JPasswordField passwordField;
    private final Set<JButton> buttons = new HashSet<JButton>();
    private String password = "";
    private boolean caps;

    private SecurePasswordInputPanel() {
        super(new GridLayout(0, 1));
        this.passwordField = new JPasswordField(10);
        this.passwordField.setEditable(false);
        this.add(this.passwordField);
        HashSet<Integer> rows = new HashSet<Integer>(KEYS_MAP.keySet());
        int n = rows.size();
        SecureRandom random = new SecureRandom();
        while (!rows.isEmpty()) {
            int row = random.nextInt() % n;
            if (!rows.contains(row)) continue;
            String[] keys = KEYS_MAP.get(row);
            rows.remove(row);
            JPanel panel = new JPanel();
            for (int column = 0; column < keys.length; ++column) {
                String text = keys[column];
                JButton button = new JButton(text);
                button.setFont(button.getFont().deriveFont(0));
                if (CLEAR.equalsIgnoreCase(text)) {
                    button.setBackground(Color.red);
                } else if (CAPS.equalsIgnoreCase(text) || BACKSPACE.equalsIgnoreCase(text)) {
                    button.setBackground(Color.lightGray);
                } else {
                    this.buttons.add(button);
                }
                button.putClientProperty("key", text);
                button.addActionListener(new MyActionListener());
                panel.add(button);
            }
            this.add(panel);
        }
    }

    public char[] getPassword() {
        return this.password.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readPassword(String prompt) {
        LookAndFeel currentLookAndFeel = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int option;
            SecurePasswordInputPanel gui = new SecurePasswordInputPanel();
            Object[] options = new String[]{OK};
            String tmpPrompt = prompt;
            if (tmpPrompt == null || tmpPrompt.isEmpty()) {
                tmpPrompt = "Password required";
            }
            if ((option = JOptionPane.showOptionDialog(null, gui, tmpPrompt, 1, -1, null, options, options[0])) == 0) {
                char[] cArray = gui.getPassword();
                return cArray;
            }
            char[] cArray = null;
            return cArray;
        }
        finally {
            try {
                UIManager.setLookAndFeel(currentLookAndFeel);
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {}
        }
    }

    static {
        int idx = 0;
        KEYS_MAP.put(idx++, new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"});
        KEYS_MAP.put(idx++, new String[]{"!", "@", "\u00a7", "#", "$", "%", "^", "&", "*", "(", ")", "{", "}"});
        KEYS_MAP.put(idx++, new String[]{"'", "\"", "=", "_", ":", ";", "?", "~", "|", ",", ".", "-", "/"});
        KEYS_MAP.put(idx++, new String[]{"q", "w", "e", "r", "z", "y", "u", "i", "o", "p"});
        KEYS_MAP.put(idx++, new String[]{"a", "s", "d", "f", "g", "h", "j", "k", "j", BACKSPACE});
        KEYS_MAP.put(idx++, new String[]{CAPS, "z", "x", "c", "v", "b", "n", "m", CLEAR});
    }

    public class MyActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            JButton btn = (JButton)event.getSource();
            String pressedKey = (String)btn.getClientProperty("key");
            if (SecurePasswordInputPanel.CAPS.equals(pressedKey)) {
                for (JButton button : SecurePasswordInputPanel.this.buttons) {
                    String text = button.getText();
                    text = SecurePasswordInputPanel.this.caps ? text.toLowerCase() : text.toUpperCase();
                    button.setText(text);
                }
                SecurePasswordInputPanel.this.caps = !SecurePasswordInputPanel.this.caps;
                return;
            }
            if (SecurePasswordInputPanel.BACKSPACE.equals(pressedKey)) {
                if (SecurePasswordInputPanel.this.password.length() > 0) {
                    SecurePasswordInputPanel.this.password = SecurePasswordInputPanel.this.password.substring(0, SecurePasswordInputPanel.this.password.length() - 1);
                }
            } else if (SecurePasswordInputPanel.CLEAR.equals(pressedKey)) {
                SecurePasswordInputPanel.this.password = "";
            } else {
                SecurePasswordInputPanel.this.password = SecurePasswordInputPanel.this.password + btn.getText();
            }
            SecurePasswordInputPanel.this.passwordField.setText(SecurePasswordInputPanel.this.password);
        }
    }
}

