/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password.callback;

import org.xipki.common.ConfPairs;
import org.xipki.common.util.StringUtil;
import org.xipki.password.PasswordResolverException;
import org.xipki.password.SecurePasswordInputPanel;
import org.xipki.password.callback.PasswordCallback;

public class GuiPasswordCallback
implements PasswordCallback {
    private int quorum = 1;
    private int tries = 3;

    protected boolean isPasswordValid(char[] password, String testToken) {
        return true;
    }

    @Override
    public char[] getPassword(String prompt, String testToken) throws PasswordResolverException {
        String tmpPrompt = prompt;
        if (StringUtil.isBlank((String)tmpPrompt)) {
            tmpPrompt = "Password required";
        }
        for (int i = 0; i < this.tries; ++i) {
            char[] password;
            if (this.quorum == 1) {
                password = SecurePasswordInputPanel.readPassword(tmpPrompt);
                if (password == null) {
                    throw new PasswordResolverException("user has cancelled");
                }
            } else {
                char[][] passwordParts = new char[this.quorum][];
                for (int j = 0; j < this.quorum; ++j) {
                    String promptPart = tmpPrompt + " (part " + (j + 1) + "/" + this.quorum + ")";
                    passwordParts[j] = SecurePasswordInputPanel.readPassword(promptPart);
                    if (passwordParts[j] != null) continue;
                    throw new PasswordResolverException("user has cancelled");
                }
                password = StringUtil.merge((char[][])passwordParts);
            }
            if (!this.isPasswordValid(password, testToken)) continue;
            return password;
        }
        throw new PasswordResolverException("Could not get the password after " + this.tries + " tries");
    }

    @Override
    public void init(String conf) throws PasswordResolverException {
        int intValue;
        if (StringUtil.isBlank((String)conf)) {
            this.quorum = 1;
            return;
        }
        ConfPairs pairs = new ConfPairs(conf);
        String str = pairs.value("quorum");
        this.quorum = Integer.valueOf(str);
        if (this.quorum < 1 || this.quorum > 10) {
            throw new PasswordResolverException("quorum " + this.quorum + " is not in [1,10]");
        }
        str = pairs.value("tries");
        if (StringUtil.isNotBlank((String)str) && (intValue = Integer.parseInt(str)) > 0) {
            this.tries = intValue;
        }
    }
}

