/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.AlgorithmCode;
import org.xipki.security.HashCalculator;

public enum HashAlgoType {
    SHA1(20, AlgorithmCode.SHA1, "1.3.14.3.2.26", "SHA1", "S1"),
    SHA224(28, AlgorithmCode.SHA224, "2.16.840.1.101.3.4.2.4", "SHA224", "S224"),
    SHA256(32, AlgorithmCode.SHA256, "2.16.840.1.101.3.4.2.1", "SHA256", "S256"),
    SHA384(48, AlgorithmCode.SHA384, "2.16.840.1.101.3.4.2.2", "SHA384", "S384"),
    SHA512(64, AlgorithmCode.SHA512, "2.16.840.1.101.3.4.2.3", "SHA512", "S512"),
    SHA3_224(28, AlgorithmCode.SHA3_224, "2.16.840.1.101.3.4.2.7", "SHA3-224", "S3-224"),
    SHA3_256(32, AlgorithmCode.SHA3_256, "2.16.840.1.101.3.4.2.8", "SHA3-256", "S3-256"),
    SHA3_384(48, AlgorithmCode.SHA3_384, "2.16.840.1.101.3.4.2.9", "SHA3-384", "S3-384"),
    SHA3_512(64, AlgorithmCode.SHA3_512, "2.16.840.1.101.3.4.2.10", "SHA3-512", "S3-512");

    private static final Map<String, HashAlgoType> map;
    private final int length;
    private final ASN1ObjectIdentifier oid;
    private final AlgorithmIdentifier algId;
    private final String name;
    private final String shortName;
    private final AlgorithmCode algorithmCode;
    private final byte[] encoded;

    private HashAlgoType(int length, AlgorithmCode algorithmCode, String oid, String name, String shortName) {
        this.length = length;
        this.algorithmCode = algorithmCode;
        this.oid = new ASN1ObjectIdentifier(oid).intern();
        this.algId = new AlgorithmIdentifier(this.oid, (ASN1Encodable)DERNull.INSTANCE);
        this.name = name;
        this.shortName = shortName;
        try {
            this.encoded = new ASN1ObjectIdentifier(oid).getEncoded();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("invalid oid: " + oid);
        }
    }

    public int length() {
        return this.length;
    }

    public AlgorithmCode algorithmCode() {
        return this.algorithmCode;
    }

    public ASN1ObjectIdentifier oid() {
        return this.oid;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public static HashAlgoType getHashAlgoType(ASN1ObjectIdentifier oid) {
        ParamUtil.requireNonNull((String)"oid", (Object)oid);
        for (HashAlgoType hashAlgo : HashAlgoType.values()) {
            if (!hashAlgo.oid.equals((Object)oid)) continue;
            return hashAlgo;
        }
        return null;
    }

    public static HashAlgoType getHashAlgoType(String nameOrOid) {
        return map.get(nameOrOid.toUpperCase());
    }

    public static HashAlgoType getNonNullHashAlgoType(ASN1ObjectIdentifier oid) {
        HashAlgoType type = HashAlgoType.getHashAlgoType(oid);
        if (type == null) {
            throw new IllegalArgumentException("Unknown HashAlgo OID '" + oid.getId() + "'");
        }
        return type;
    }

    public static HashAlgoType getNonNullHashAlgoType(String nameOrOid) {
        HashAlgoType type = HashAlgoType.getHashAlgoType(nameOrOid);
        if (type == null) {
            throw new IllegalArgumentException("Unknown HashAlgo OID/name '" + nameOrOid + "'");
        }
        return type;
    }

    public static HashAlgoType getInstanceForPkcs11HashMech(long hashMech) {
        if (hashMech == 544L) {
            return SHA1;
        }
        if (hashMech == 597L) {
            return SHA224;
        }
        if (hashMech == 592L) {
            return SHA256;
        }
        if (hashMech == 608L) {
            return SHA384;
        }
        if (hashMech == 624L) {
            return SHA512;
        }
        if (hashMech == 693L) {
            return SHA3_224;
        }
        if (hashMech == 688L) {
            return SHA3_256;
        }
        if (hashMech == 704L) {
            return SHA3_384;
        }
        if (hashMech == 720L) {
            return SHA3_512;
        }
        return null;
    }

    public static HashAlgoType getInstanceForPkcs11MgfMech(long hashMech) {
        if (hashMech == 1L) {
            return SHA1;
        }
        if (hashMech == 5L) {
            return SHA224;
        }
        if (hashMech == 2L) {
            return SHA256;
        }
        if (hashMech == 3L) {
            return SHA384;
        }
        if (hashMech == 4L) {
            return SHA512;
        }
        if (hashMech == 6L) {
            return SHA3_224;
        }
        if (hashMech == 7L) {
            return SHA3_256;
        }
        if (hashMech == 8L) {
            return SHA3_384;
        }
        if (hashMech == 9L) {
            return SHA3_512;
        }
        return null;
    }

    public static HashAlgoType getInstanceForEncoded(byte[] encoded) {
        return HashAlgoType.getInstanceForEncoded(encoded, 0, encoded.length);
    }

    public static HashAlgoType getInstanceForEncoded(byte[] encoded, int offset, int len) {
        for (HashAlgoType value : HashAlgoType.values()) {
            byte[] ve = value.encoded;
            if (ve.length != len) continue;
            boolean equals = true;
            for (int i = 0; i < len; ++i) {
                if (ve[i] == encoded[offset + i]) continue;
                equals = false;
                break;
            }
            if (!equals) continue;
            return value;
        }
        return null;
    }

    public AlgorithmIdentifier algorithmIdentifier() {
        return this.algId;
    }

    public Digest createDigest() {
        switch (this) {
            case SHA1: {
                return new SHA1Digest();
            }
            case SHA224: {
                return new SHA224Digest();
            }
            case SHA256: {
                return new SHA256Digest();
            }
            case SHA384: {
                return new SHA384Digest();
            }
            case SHA512: {
                return new SHA512Digest();
            }
            case SHA3_224: {
                return new SHA3Digest(224);
            }
            case SHA3_256: {
                return new SHA3Digest(256);
            }
            case SHA3_384: {
                return new SHA3Digest(384);
            }
            case SHA3_512: {
                return new SHA3Digest(512);
            }
        }
        throw new RuntimeException("should not reach here, unknown HashAlgoType " + this.name());
    }

    public String hexHash(byte[] data) {
        return HashCalculator.hexHash(this, data);
    }

    public String base64Hash(byte[] data) {
        return HashCalculator.base64Hash(this, data);
    }

    public byte[] hash(byte[] data) {
        return HashCalculator.hash(this, data);
    }

    public int encodedLength() {
        return this.encoded.length;
    }

    public int write(byte[] out, int offset) {
        System.arraycopy(this.encoded, 0, out, offset, this.encoded.length);
        return this.encoded.length;
    }

    static {
        map = new HashMap<String, HashAlgoType>();
        for (HashAlgoType type : HashAlgoType.values()) {
            map.put(type.oid.getId(), type);
            map.put(type.name, type);
        }
        map.put("SHA-1", SHA1);
        map.put("SHA-224", SHA224);
        map.put("SHA-256", SHA256);
        map.put("SHA-384", SHA384);
        map.put("SHA-512", SHA512);
        map.put("SHA3224", SHA3_224);
        map.put("SHA3256", SHA3_256);
        map.put("SHA3384", SHA3_384);
        map.put("SHA3512", SHA3_512);
    }
}

