/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.util.encoders.Hex;
import org.xipki.common.ConfPairs;
import org.xipki.common.util.Base64;
import org.xipki.common.util.IoUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.security.HashAlgoType;
import org.xipki.security.SignatureAlgoControl;

public class SignerConf {
    private final ConfPairs confPairs;
    private final HashAlgoType hashAlgo;
    private final SignatureAlgoControl signatureAlgoControl;

    public SignerConf(String conf) {
        this.hashAlgo = null;
        this.signatureAlgoControl = null;
        ParamUtil.requireNonBlank((String)"conf", (String)conf);
        this.confPairs = new ConfPairs(conf);
        if (this.getConfValue("algo") == null) {
            throw new IllegalArgumentException("conf must contain the entry 'algo'");
        }
    }

    public SignerConf(String confWithoutAlgo, HashAlgoType hashAlgo, SignatureAlgoControl signatureAlgoControl) {
        ParamUtil.requireNonBlank((String)"confWithoutAlgo", (String)confWithoutAlgo);
        this.hashAlgo = (HashAlgoType)((Object)ParamUtil.requireNonNull((String)"hashAlgo", (Object)((Object)hashAlgo)));
        this.signatureAlgoControl = signatureAlgoControl;
        this.confPairs = new ConfPairs(confWithoutAlgo);
        if (this.getConfValue("algo") != null) {
            throw new IllegalArgumentException("confWithoutAlgo must not contain the entry 'algo'");
        }
    }

    public HashAlgoType hashAlgo() {
        return this.hashAlgo;
    }

    public SignatureAlgoControl signatureAlgoControl() {
        return this.signatureAlgoControl;
    }

    public void putConfEntry(String name, String value) {
        this.confPairs.putPair(name, value);
    }

    public void removeConfEntry(String name) {
        this.confPairs.removePair(name);
    }

    public String getConfValue(String name) {
        return this.confPairs.value(name);
    }

    public String getConf() {
        return this.confPairs.getEncoded();
    }

    public String toString() {
        return this.toString(true, true);
    }

    public String toString(boolean verbose, boolean ignoreSensitiveInfo) {
        String conf = this.getConf();
        if (ignoreSensitiveInfo) {
            conf = SignerConf.eraseSensitiveData(conf);
        }
        StringBuilder sb = new StringBuilder(conf.length() + 50);
        sb.append("conf: ");
        sb.append(conf);
        if (this.hashAlgo != null) {
            sb.append("\nhash algo: ").append(this.hashAlgo.getName());
        }
        if (this.signatureAlgoControl != null) {
            sb.append("\nsiganture algo control: ").append(this.signatureAlgoControl);
        }
        return sb.toString();
    }

    public static String toString(String signerConf, boolean verbose, boolean ignoreSensitiveInfo) {
        String tmpSignerConf = ParamUtil.requireNonBlank((String)"signerConf", (String)signerConf);
        if (ignoreSensitiveInfo) {
            tmpSignerConf = SignerConf.eraseSensitiveData(tmpSignerConf);
        }
        if (verbose || tmpSignerConf.length() < 101) {
            return tmpSignerConf;
        }
        return tmpSignerConf.substring(0, 97) + "...";
    }

    public static SignerConf getKeystoreSignerConf(InputStream keystoreStream, String password, String signatureAlgorithm, int parallelism) throws IOException {
        ParamUtil.requireNonNull((String)"keystoreStream", (Object)keystoreStream);
        ParamUtil.requireNonBlank((String)"password", (String)password);
        ParamUtil.requireNonNull((String)"signatureAlgorithm", (Object)signatureAlgorithm);
        ParamUtil.requireMin((String)"parallelism", (int)parallelism, (int)1);
        ConfPairs conf = new ConfPairs("password", password);
        conf.putPair("algo", signatureAlgorithm);
        conf.putPair("parallelism", Integer.toString(parallelism));
        conf.putPair("keystore", "base64:" + Base64.encodeToString((byte[])IoUtil.read((InputStream)keystoreStream)));
        return new SignerConf(conf.getEncoded());
    }

    public static SignerConf getKeystoreSignerConf(String keystoreFile, String password, int parallelism, HashAlgoType hashAlgo, SignatureAlgoControl signatureAlgoControl) {
        ParamUtil.requireNonBlank((String)"keystoreFile", (String)keystoreFile);
        ParamUtil.requireNonBlank((String)"password", (String)password);
        ParamUtil.requireMin((String)"parallelism", (int)parallelism, (int)1);
        ParamUtil.requireNonNull((String)"hashAlgo", (Object)((Object)hashAlgo));
        ConfPairs conf = new ConfPairs("password", password);
        conf.putPair("parallelism", Integer.toString(parallelism));
        conf.putPair("keystore", "file:" + keystoreFile);
        return new SignerConf(conf.getEncoded(), hashAlgo, signatureAlgoControl);
    }

    public static SignerConf getKeystoreSignerConf(String keystoreFile, String password, HashAlgoType hashAlgo, SignatureAlgoControl signatureAlgoControl) {
        ParamUtil.requireNonBlank((String)"keystoreFile", (String)keystoreFile);
        ParamUtil.requireNonBlank((String)"password", (String)password);
        ParamUtil.requireNonNull((String)"hashAlgo", (Object)((Object)hashAlgo));
        ConfPairs conf = new ConfPairs("password", password);
        conf.putPair("parallelism", "1");
        conf.putPair("keystore", "file:" + keystoreFile);
        return new SignerConf(conf.getEncoded(), hashAlgo, signatureAlgoControl);
    }

    public static SignerConf getPkcs11SignerConf(String pkcs11ModuleName, Integer slotIndex, Long slotId, String keyLabel, byte[] keyId, int parallelism, HashAlgoType hashAlgo, SignatureAlgoControl signatureAlgoControl) {
        ParamUtil.requireMin((String)"parallelism", (int)parallelism, (int)1);
        ParamUtil.requireNonNull((String)"hashAlgo", (Object)((Object)hashAlgo));
        if (slotIndex == null && slotId == null) {
            throw new IllegalArgumentException("at least one of slotIndex and slotId must not be null");
        }
        if (keyId == null && keyLabel == null) {
            throw new IllegalArgumentException("at least one of keyId and keyLabel must not be null");
        }
        ConfPairs conf = new ConfPairs();
        conf.putPair("parallelism", Integer.toString(parallelism));
        if (pkcs11ModuleName != null && pkcs11ModuleName.length() > 0) {
            conf.putPair("module", pkcs11ModuleName);
        }
        if (slotId != null) {
            conf.putPair("slot-id", slotId.toString());
        }
        if (slotIndex != null) {
            conf.putPair("slot", slotIndex.toString());
        }
        if (keyId != null) {
            conf.putPair("key-id", Hex.toHexString((byte[])keyId));
        }
        if (keyLabel != null) {
            conf.putPair("key-label", keyLabel);
        }
        return new SignerConf(conf.getEncoded(), hashAlgo, signatureAlgoControl);
    }

    public static SignerConf getPkcs11SignerConf(String pkcs11ModuleName, Integer slotIndex, Long slotId, String keyLabel, byte[] keyId, String signatureAlgorithm, int parallelism) {
        ParamUtil.requireMin((String)"parallelism", (int)parallelism, (int)1);
        ParamUtil.requireNonNull((String)"algo", (Object)signatureAlgorithm);
        if (slotIndex == null && slotId == null) {
            throw new IllegalArgumentException("at least one of slotIndex and slotId must not be null");
        }
        if (keyId == null && keyLabel == null) {
            throw new IllegalArgumentException("at least one of keyId and keyLabel must not be null");
        }
        ConfPairs conf = new ConfPairs("algo", signatureAlgorithm);
        conf.putPair("parallelism", Integer.toString(parallelism));
        if (pkcs11ModuleName != null && pkcs11ModuleName.length() > 0) {
            conf.putPair("module", pkcs11ModuleName);
        }
        if (slotId != null) {
            conf.putPair("slot-id", slotId.toString());
        }
        if (slotIndex != null) {
            conf.putPair("slot", slotIndex.toString());
        }
        if (keyId != null) {
            conf.putPair("key-id", Hex.toHexString((byte[])keyId));
        }
        if (keyLabel != null) {
            conf.putPair("key-label", keyLabel);
        }
        return new SignerConf(conf.getEncoded());
    }

    private static String eraseSensitiveData(String conf) {
        if (conf == null || !conf.contains("password?")) {
            return conf;
        }
        try {
            ConfPairs pairs = new ConfPairs(conf);
            String value = pairs.value("password");
            if (value != null && !StringUtil.startsWithIgnoreCase((String)value, (String)"PBE:")) {
                pairs.putPair("password", "<sensitive>");
            }
            return pairs.getEncoded();
        }
        catch (Exception ex) {
            return conf;
        }
    }
}

