/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.InvalidConfException;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.password.PasswordResolver;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.P11Conf;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.emulator.EmulatorP11Module;
import org.xipki.security.pkcs11.iaik.IaikP11Module;
import org.xipki.security.pkcs11.proxy.ProxyP11Module;

public class P11CryptServiceFactoryImpl
implements P11CryptServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(P11CryptServiceFactoryImpl.class);
    private static final Map<String, P11CryptService> services = new HashMap<String, P11CryptService>();
    private static final Map<String, P11Module> modules = new HashMap<String, P11Module>();
    private PasswordResolver passwordResolver;
    private P11Conf p11Conf;
    private String pkcs11ConfFile;

    public synchronized void init() throws InvalidConfException, IOException {
        if (this.p11Conf != null) {
            return;
        }
        if (StringUtil.isBlank((String)this.pkcs11ConfFile)) {
            LOG.error("no pkcs11ConfFile is configured, could not initialize");
            return;
        }
        this.p11Conf = new P11Conf(new FileInputStream(this.pkcs11ConfFile), this.passwordResolver);
    }

    @Override
    public synchronized P11CryptService getP11CryptService(String moduleName) throws XiSecurityException, P11TokenException {
        if (this.p11Conf == null) {
            throw new IllegalStateException("please set pkcs11ConfFile and then call init() first");
        }
        String name = this.getModuleName(moduleName);
        P11ModuleConf conf = this.p11Conf.moduleConf(name);
        if (conf == null) {
            throw new XiSecurityException("PKCS#11 module " + name + " is not defined");
        }
        P11CryptService instance = services.get(moduleName);
        if (instance != null) {
            return instance;
        }
        String nativeLib = conf.nativeLibrary();
        P11Module p11Module = modules.get(nativeLib);
        if (p11Module == null) {
            p11Module = StringUtil.startsWithIgnoreCase((String)nativeLib, (String)"proxy:") ? ProxyP11Module.getInstance(conf) : (StringUtil.startsWithIgnoreCase((String)nativeLib, (String)"emulator:") ? EmulatorP11Module.getInstance(conf) : IaikP11Module.getInstance(conf));
        }
        modules.put(nativeLib, p11Module);
        instance = new P11CryptService(p11Module);
        services.put(moduleName, instance);
        return instance;
    }

    private String getModuleName(String moduleName) {
        return moduleName == null ? "default" : moduleName;
    }

    public void setPkcs11ConfFile(String confFile) {
        this.pkcs11ConfFile = StringUtil.isBlank((String)confFile) ? null : confFile;
    }

    public void setPasswordResolver(PasswordResolver passwordResolver) {
        this.passwordResolver = passwordResolver;
    }

    @Override
    public void shutdown() {
        for (String pk11Lib : modules.keySet()) {
            try {
                modules.get(pk11Lib).close();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)("could not close PKCS11 Module " + pk11Lib));
            }
        }
        modules.clear();
        services.clear();
    }

    @Override
    public Set<String> moduleNames() {
        if (this.p11Conf == null) {
            throw new IllegalStateException("pkcs11ConfFile is not set");
        }
        return this.p11Conf.moduleNames();
    }
}

