/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.P11UnsupportedMechanismException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.P11EntityIdentifier;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11RSAPkcsPssParams;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.Pkcs11Functions;

public abstract class P11Identity
implements Comparable<P11Identity> {
    private static final Logger LOG = LoggerFactory.getLogger(P11Identity.class);
    protected final P11Slot slot;
    protected final P11EntityIdentifier identityId;
    protected final PublicKey publicKey;
    private final int signatureKeyBitLength;
    protected X509Certificate[] certificateChain;

    protected P11Identity(P11Slot slot, P11EntityIdentifier identityId, int signatureBitLen) {
        this.slot = (P11Slot)ParamUtil.requireNonNull((String)"slot", (Object)slot);
        this.identityId = (P11EntityIdentifier)ParamUtil.requireNonNull((String)"identityId", (Object)identityId);
        this.publicKey = null;
        this.signatureKeyBitLength = signatureBitLen;
    }

    protected P11Identity(P11Slot slot, P11EntityIdentifier identityId, PublicKey publicKey, X509Certificate[] certificateChain) {
        this.slot = (P11Slot)ParamUtil.requireNonNull((String)"slot", (Object)slot);
        this.identityId = (P11EntityIdentifier)ParamUtil.requireNonNull((String)"identityId", (Object)identityId);
        if ((certificateChain == null || certificateChain.length < 1 || certificateChain[0] == null) && publicKey == null) {
            throw new IllegalArgumentException("neither certificate nor publicKey is non-null");
        }
        X509Certificate[] x509CertificateArray = this.certificateChain = certificateChain != null && certificateChain.length > 0 ? certificateChain : null;
        this.publicKey = publicKey != null ? publicKey : (certificateChain != null && certificateChain.length > 0 ? certificateChain[0].getPublicKey() : null);
        if (this.publicKey instanceof RSAPublicKey) {
            this.signatureKeyBitLength = ((RSAPublicKey)this.publicKey).getModulus().bitLength();
        } else if (this.publicKey instanceof ECPublicKey) {
            this.signatureKeyBitLength = ((ECPublicKey)this.publicKey).getParams().getOrder().bitLength();
        } else if (this.publicKey instanceof DSAPublicKey) {
            this.signatureKeyBitLength = ((DSAPublicKey)this.publicKey).getParams().getQ().bitLength();
        } else {
            throw new IllegalArgumentException("currently only RSA, DSA and EC public key are supported, but not " + this.publicKey.getAlgorithm() + " (class: " + this.publicKey.getClass().getName() + ")");
        }
    }

    public byte[] sign(long mechanism, P11Params parameters, byte[] content) throws P11TokenException, XiSecurityException {
        ParamUtil.requireNonNull((String)"content", (Object)content);
        this.slot.assertMechanismSupported(mechanism);
        if (!this.supportsMechanism(mechanism, parameters)) {
            throw new P11UnsupportedMechanismException(mechanism, this.identityId);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("sign with mechanism {}", (Object)Pkcs11Functions.getMechanismDesc(mechanism));
        }
        return this.sign0(mechanism, parameters, content);
    }

    protected abstract byte[] sign0(long var1, P11Params var3, byte[] var4) throws P11TokenException;

    public byte[] digestSecretKey(long mechanism) throws P11TokenException, XiSecurityException {
        this.slot.assertMechanismSupported(mechanism);
        if (LOG.isDebugEnabled()) {
            LOG.debug("digest secret with mechanism {}", (Object)Pkcs11Functions.getMechanismDesc(mechanism));
        }
        return this.digestSecretKey0(mechanism);
    }

    protected abstract byte[] digestSecretKey0(long var1) throws P11TokenException;

    public P11EntityIdentifier identityId() {
        return this.identityId;
    }

    public X509Certificate certificate() {
        return this.certificateChain != null && this.certificateChain.length > 0 ? this.certificateChain[0] : null;
    }

    public X509Certificate[] certificateChain() {
        return this.certificateChain == null ? null : Arrays.copyOf(this.certificateChain, this.certificateChain.length);
    }

    public PublicKey publicKey() {
        return this.publicKey;
    }

    public void setCertificates(X509Certificate[] certificateChain) throws P11TokenException {
        if (certificateChain == null || certificateChain.length == 0) {
            this.certificateChain = null;
        } else {
            PublicKey pk = certificateChain[0].getPublicKey();
            if (!this.publicKey.equals(pk)) {
                throw new P11TokenException("certificateChain is not for the key");
            }
            this.certificateChain = certificateChain;
        }
    }

    public boolean match(P11EntityIdentifier identityId) {
        return this.identityId.equals(identityId);
    }

    public boolean match(P11SlotIdentifier slotId, String keyLabel) {
        return this.identityId.match(slotId, keyLabel);
    }

    public int signatureKeyBitLength() {
        return this.signatureKeyBitLength;
    }

    @Override
    public int compareTo(P11Identity obj) {
        return this.identityId.compareTo(obj.identityId);
    }

    public boolean supportsMechanism(long mechanism, P11Params parameters) {
        if (this.publicKey == null && (545L == mechanism || 598L == mechanism || 593L == mechanism || 609L == mechanism || 625L == mechanism || 694L == mechanism || 689L == mechanism || 705L == mechanism || 721L == mechanism)) {
            return true;
        }
        if (this.publicKey instanceof RSAPublicKey) {
            if (2L == mechanism || 1L == mechanism || 6L == mechanism || 70L == mechanism || 64L == mechanism || 65L == mechanism || 66L == mechanism) {
                return parameters == null;
            }
            if (13L == mechanism || 14L == mechanism || 71L == mechanism || 67L == mechanism || 68L == mechanism || 69L == mechanism) {
                return parameters instanceof P11RSAPkcsPssParams;
            }
            if (3L == mechanism) {
                return true;
            }
        } else if (this.publicKey instanceof DSAPublicKey) {
            if (parameters != null) {
                return false;
            }
            if (17L == mechanism || 18L == mechanism || 19L == mechanism || 20L == mechanism || 21L == mechanism || 22L == mechanism) {
                return true;
            }
        } else if (this.publicKey instanceof ECPublicKey) {
            if (parameters != null) {
                return false;
            }
            if (4161L == mechanism || 4162L == mechanism || 4163L == mechanism || 4164L == mechanism || 4165L == mechanism || 4166L == mechanism) {
                return true;
            }
        }
        return false;
    }
}

