/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DefaultConcurrentContentSigner;
import org.xipki.security.bc.XiContentSigner;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11EntityIdentifier;
import org.xipki.security.pkcs11.P11MacContentSigner;

public class P11MacContentSignerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(P11MacContentSignerBuilder.class);
    private final P11CryptService cryptService;
    private final P11EntityIdentifier identityId;

    public P11MacContentSignerBuilder(P11CryptService cryptService, P11EntityIdentifier identityId) throws XiSecurityException, P11TokenException {
        this.cryptService = (P11CryptService)ParamUtil.requireNonNull((String)"cryptService", (Object)cryptService);
        this.identityId = (P11EntityIdentifier)ParamUtil.requireNonNull((String)"identityId", (Object)identityId);
    }

    public ConcurrentContentSigner createSigner(AlgorithmIdentifier signatureAlgId, int parallelism) throws XiSecurityException, P11TokenException {
        DefaultConcurrentContentSigner concurrentSigner;
        ParamUtil.requireMin((String)"parallelism", (int)parallelism, (int)1);
        ArrayList<XiContentSigner> signers = new ArrayList<XiContentSigner>(parallelism);
        for (int i = 0; i < parallelism; ++i) {
            P11MacContentSigner signer = new P11MacContentSigner(this.cryptService, this.identityId, signatureAlgId);
            signers.add(signer);
        }
        boolean mac = true;
        try {
            concurrentSigner = new DefaultConcurrentContentSigner(true, signers, null);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
        try {
            byte[] sha1HashOfKey = this.cryptService.getIdentity(this.identityId).digestSecretKey(544L);
            concurrentSigner.setSha1DigestOfMacKey(sha1HashOfKey);
        }
        catch (P11TokenException | XiSecurityException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not compute the digest of secret key " + this.identityId));
        }
        return concurrentSigner;
    }
}

