/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.HashAlgoType;
import org.xipki.security.bc.XiContentSigner;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.DigestOutputStream;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11EntityIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.util.SignerUtil;

class P11RSAContentSigner
implements XiContentSigner {
    private static final Logger LOG = LoggerFactory.getLogger(P11RSAContentSigner.class);
    private final AlgorithmIdentifier algorithmIdentifier;
    private final byte[] encodedAlgorithmIdentifier;
    private final long mechanism;
    private final OutputStream outputStream;
    private final P11CryptService cryptService;
    private final P11EntityIdentifier identityId;
    private final byte[] digestPkcsPrefix;
    private final int modulusBitLen;

    P11RSAContentSigner(P11CryptService cryptService, P11EntityIdentifier identityId, AlgorithmIdentifier signatureAlgId) throws XiSecurityException, P11TokenException {
        HashAlgoType hashAlgo;
        this.cryptService = (P11CryptService)ParamUtil.requireNonNull((String)"cryptService", (Object)cryptService);
        this.identityId = (P11EntityIdentifier)ParamUtil.requireNonNull((String)"identityId", (Object)identityId);
        this.algorithmIdentifier = (AlgorithmIdentifier)ParamUtil.requireNonNull((String)"signatureAlgId", (Object)signatureAlgId);
        try {
            this.encodedAlgorithmIdentifier = this.algorithmIdentifier.getEncoded();
        }
        catch (IOException ex) {
            throw new XiSecurityException("could not encode AlgorithmIdentifier", ex);
        }
        ASN1ObjectIdentifier algOid = signatureAlgId.getAlgorithm();
        if (PKCSObjectIdentifiers.sha1WithRSAEncryption.equals((Object)algOid)) {
            hashAlgo = HashAlgoType.SHA1;
        } else if (PKCSObjectIdentifiers.sha224WithRSAEncryption.equals((Object)algOid)) {
            hashAlgo = HashAlgoType.SHA224;
        } else if (PKCSObjectIdentifiers.sha256WithRSAEncryption.equals((Object)algOid)) {
            hashAlgo = HashAlgoType.SHA256;
        } else if (PKCSObjectIdentifiers.sha384WithRSAEncryption.equals((Object)algOid)) {
            hashAlgo = HashAlgoType.SHA384;
        } else if (PKCSObjectIdentifiers.sha512WithRSAEncryption.equals((Object)algOid)) {
            hashAlgo = HashAlgoType.SHA512;
        } else if (NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224.equals((Object)algOid)) {
            hashAlgo = HashAlgoType.SHA3_224;
        } else if (NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256.equals((Object)algOid)) {
            hashAlgo = HashAlgoType.SHA3_256;
        } else if (NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384.equals((Object)algOid)) {
            hashAlgo = HashAlgoType.SHA3_384;
        } else if (NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512.equals((Object)algOid)) {
            hashAlgo = HashAlgoType.SHA3_512;
        } else {
            throw new XiSecurityException("unsupported signature algorithm " + algOid.getId());
        }
        P11SlotIdentifier slotId = identityId.slotId();
        P11Slot slot = cryptService.getSlot(slotId);
        if (slot.supportsMechanism(1L)) {
            this.mechanism = 1L;
        } else if (slot.supportsMechanism(3L)) {
            this.mechanism = 3L;
        } else {
            switch (hashAlgo) {
                case SHA1: {
                    this.mechanism = 6L;
                    break;
                }
                case SHA224: {
                    this.mechanism = 70L;
                    break;
                }
                case SHA256: {
                    this.mechanism = 64L;
                    break;
                }
                case SHA384: {
                    this.mechanism = 65L;
                    break;
                }
                case SHA512: {
                    this.mechanism = 66L;
                    break;
                }
                case SHA3_224: {
                    this.mechanism = 102L;
                    break;
                }
                case SHA3_256: {
                    this.mechanism = 96L;
                    break;
                }
                case SHA3_384: {
                    this.mechanism = 97L;
                    break;
                }
                case SHA3_512: {
                    this.mechanism = 98L;
                    break;
                }
                default: {
                    throw new RuntimeException("should not reach here, unknown HashAlgoType " + (Object)((Object)hashAlgo));
                }
            }
            if (!slot.supportsMechanism(this.mechanism)) {
                throw new XiSecurityException("unsupported signature algorithm " + algOid.getId());
            }
        }
        if (this.mechanism == 1L || this.mechanism == 3L) {
            this.digestPkcsPrefix = SignerUtil.getDigestPkcsPrefix(hashAlgo);
            Digest digest = SignerUtil.getDigest(hashAlgo);
            this.outputStream = new DigestOutputStream(digest);
        } else {
            this.digestPkcsPrefix = null;
            this.outputStream = new ByteArrayOutputStream();
        }
        RSAPublicKey rsaPubKey = (RSAPublicKey)cryptService.getIdentity(identityId).publicKey();
        this.modulusBitLen = rsaPubKey.getModulus().bitLength();
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public byte[] getEncodedAlgorithmIdentifier() {
        return Arrays.copyOf(this.encodedAlgorithmIdentifier, this.encodedAlgorithmIdentifier.length);
    }

    public OutputStream getOutputStream() {
        if (this.outputStream instanceof ByteArrayOutputStream) {
            ((ByteArrayOutputStream)this.outputStream).reset();
        } else {
            ((DigestOutputStream)this.outputStream).reset();
        }
        return this.outputStream;
    }

    public byte[] getSignature() {
        byte[] dataToSign;
        if (this.outputStream instanceof ByteArrayOutputStream) {
            dataToSign = ((ByteArrayOutputStream)this.outputStream).toByteArray();
            ((ByteArrayOutputStream)this.outputStream).reset();
        } else {
            byte[] hashValue = ((DigestOutputStream)this.outputStream).digest();
            ((DigestOutputStream)this.outputStream).reset();
            dataToSign = new byte[this.digestPkcsPrefix.length + hashValue.length];
            System.arraycopy(this.digestPkcsPrefix, 0, dataToSign, 0, this.digestPkcsPrefix.length);
            System.arraycopy(hashValue, 0, dataToSign, this.digestPkcsPrefix.length, hashValue.length);
        }
        try {
            if (this.mechanism == 3L) {
                dataToSign = SignerUtil.EMSA_PKCS1_v1_5_encoding(dataToSign, this.modulusBitLen);
            }
            return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, null, dataToSign);
        }
        catch (P11TokenException | XiSecurityException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not sign");
            throw new RuntimeCryptoException("SignerException: " + ex.getMessage());
        }
    }
}

