/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.HashAlgoType;
import org.xipki.security.bc.XiContentSigner;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.DigestOutputStream;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11EntityIdentifier;
import org.xipki.security.pkcs11.P11PlainRSASigner;
import org.xipki.security.pkcs11.P11RSAKeyParameter;
import org.xipki.security.pkcs11.P11RSAPkcsPssParams;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.util.SignerUtil;

class P11RSAPSSContentSigner
implements XiContentSigner {
    private static final Logger LOG = LoggerFactory.getLogger(P11RSAPSSContentSigner.class);
    private final AlgorithmIdentifier algorithmIdentifier;
    private final byte[] encodedAlgorithmIdentifier;
    private final P11CryptService cryptService;
    private final P11EntityIdentifier identityId;
    private final long mechanism;
    private final P11RSAPkcsPssParams parameters;
    private final OutputStream outputStream;

    P11RSAPSSContentSigner(P11CryptService cryptService, P11EntityIdentifier identityId, AlgorithmIdentifier signatureAlgId, SecureRandom random) throws XiSecurityException, P11TokenException {
        this.cryptService = (P11CryptService)ParamUtil.requireNonNull((String)"cryptService", (Object)cryptService);
        this.identityId = (P11EntityIdentifier)ParamUtil.requireNonNull((String)"identityId", (Object)identityId);
        this.algorithmIdentifier = (AlgorithmIdentifier)ParamUtil.requireNonNull((String)"signatureAlgId", (Object)signatureAlgId);
        try {
            this.encodedAlgorithmIdentifier = this.algorithmIdentifier.getEncoded();
        }
        catch (IOException ex) {
            throw new XiSecurityException("could not encode AlgorithmIdentifier", ex);
        }
        ParamUtil.requireNonNull((String)"random", (Object)random);
        if (!PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)signatureAlgId.getAlgorithm())) {
            throw new XiSecurityException("unsupported signature algorithm " + signatureAlgId.getAlgorithm());
        }
        RSASSAPSSparams asn1Params = RSASSAPSSparams.getInstance((Object)signatureAlgId.getParameters());
        ASN1ObjectIdentifier digestAlgOid = asn1Params.getHashAlgorithm().getAlgorithm();
        HashAlgoType hashAlgo = HashAlgoType.getHashAlgoType(digestAlgOid);
        if (hashAlgo == null) {
            throw new XiSecurityException("unsupported hash algorithm " + digestAlgOid.getId());
        }
        P11SlotIdentifier slotId = identityId.slotId();
        P11Slot slot = cryptService.getSlot(slotId);
        if (slot.supportsMechanism(13L)) {
            this.mechanism = 13L;
            this.parameters = new P11RSAPkcsPssParams(asn1Params);
            Digest digest = SignerUtil.getDigest(hashAlgo);
            this.outputStream = new DigestOutputStream(digest);
        } else if (slot.supportsMechanism(3L)) {
            P11RSAKeyParameter keyParam;
            this.mechanism = 3L;
            this.parameters = null;
            P11PlainRSASigner cipher = new P11PlainRSASigner();
            try {
                keyParam = P11RSAKeyParameter.getInstance(cryptService, identityId);
            }
            catch (InvalidKeyException ex) {
                throw new XiSecurityException(ex.getMessage(), ex);
            }
            PSSSigner pssSigner = SignerUtil.createPSSRSASigner(signatureAlgId, cipher);
            pssSigner.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)keyParam, random));
            this.outputStream = new PSSSignerOutputStream(pssSigner);
        } else {
            switch (hashAlgo) {
                case SHA1: {
                    this.mechanism = 14L;
                    break;
                }
                case SHA224: {
                    this.mechanism = 71L;
                    break;
                }
                case SHA256: {
                    this.mechanism = 67L;
                    break;
                }
                case SHA384: {
                    this.mechanism = 68L;
                    break;
                }
                case SHA512: {
                    this.mechanism = 69L;
                    break;
                }
                case SHA3_224: {
                    this.mechanism = 103L;
                    break;
                }
                case SHA3_256: {
                    this.mechanism = 99L;
                    break;
                }
                case SHA3_384: {
                    this.mechanism = 100L;
                    break;
                }
                case SHA3_512: {
                    this.mechanism = 101L;
                    break;
                }
                default: {
                    throw new RuntimeException("should not reach here, unknown HashAlgoType " + (Object)((Object)hashAlgo));
                }
            }
            if (!slot.supportsMechanism(this.mechanism)) {
                throw new XiSecurityException("unsupported signature algorithm " + PKCSObjectIdentifiers.id_RSASSA_PSS.getId() + " with " + (Object)((Object)hashAlgo));
            }
            this.parameters = new P11RSAPkcsPssParams(asn1Params);
            this.outputStream = new ByteArrayOutputStream();
        }
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public byte[] getEncodedAlgorithmIdentifier() {
        return Arrays.copyOf(this.encodedAlgorithmIdentifier, this.encodedAlgorithmIdentifier.length);
    }

    public OutputStream getOutputStream() {
        if (this.outputStream instanceof ByteArrayOutputStream) {
            ((ByteArrayOutputStream)this.outputStream).reset();
        } else if (this.outputStream instanceof DigestOutputStream) {
            ((DigestOutputStream)this.outputStream).reset();
        } else {
            ((PSSSignerOutputStream)this.outputStream).reset();
        }
        return this.outputStream;
    }

    public byte[] getSignature() {
        if (this.outputStream instanceof PSSSignerOutputStream) {
            try {
                return ((PSSSignerOutputStream)this.outputStream).generateSignature();
            }
            catch (CryptoException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex);
                throw new RuntimeCryptoException("CryptoException: " + ex.getMessage());
            }
        }
        byte[] dataToSign = this.outputStream instanceof ByteArrayOutputStream ? ((ByteArrayOutputStream)this.outputStream).toByteArray() : ((DigestOutputStream)this.outputStream).digest();
        try {
            return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, this.parameters, dataToSign);
        }
        catch (P11TokenException | XiSecurityException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"could not sign");
            throw new RuntimeCryptoException("SignerException: " + ex.getMessage());
        }
    }

    private static class PSSSignerOutputStream
    extends OutputStream {
        private PSSSigner pssSigner;

        PSSSignerOutputStream(PSSSigner pssSigner) {
            this.pssSigner = pssSigner;
        }

        @Override
        public void write(int oneByte) throws IOException {
            this.pssSigner.update((byte)oneByte);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.pssSigner.update(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.pssSigner.update(bytes, off, len);
        }

        public void reset() {
            this.pssSigner.reset();
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        byte[] generateSignature() throws DataLengthException, CryptoException {
            byte[] signature = this.pssSigner.generateSignature();
            this.pssSigner.reset();
            return signature;
        }
    }
}

