/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xipki.security.HashAlgoType;
import org.xipki.security.pkcs11.P11Params;

public class P11RSAPkcsPssParams
implements P11Params {
    private final long hashAlgorithm;
    private final long maskGenerationFunction;
    private final long saltLength;

    public P11RSAPkcsPssParams(long hashAlgorithm, long maskGenerationFunction, long saltLength) {
        this.hashAlgorithm = hashAlgorithm;
        this.maskGenerationFunction = maskGenerationFunction;
        this.saltLength = saltLength;
    }

    public P11RSAPkcsPssParams(RSASSAPSSparams asn1Params) {
        ASN1ObjectIdentifier asn1Oid = asn1Params.getHashAlgorithm().getAlgorithm();
        HashAlgoType contentHashAlgo = HashAlgoType.getHashAlgoType(asn1Oid);
        if (contentHashAlgo == null) {
            throw new IllegalArgumentException("unsupported hash algorithm " + asn1Oid.getId());
        }
        AlgorithmIdentifier mga = asn1Params.getMaskGenAlgorithm();
        asn1Oid = mga.getAlgorithm();
        if (!PKCSObjectIdentifiers.id_mgf1.equals((Object)asn1Oid)) {
            throw new IllegalArgumentException("unsupported MGF algorithm " + asn1Oid.getId());
        }
        asn1Oid = AlgorithmIdentifier.getInstance((Object)mga.getParameters()).getAlgorithm();
        HashAlgoType mgfHashAlgo = HashAlgoType.getHashAlgoType(asn1Oid);
        if (mgfHashAlgo == null) {
            throw new IllegalArgumentException("unsupported MGF hash algorithm " + asn1Oid.getId());
        }
        this.saltLength = asn1Params.getSaltLength().longValue();
        BigInteger trailerField = asn1Params.getTrailerField();
        if (!RSASSAPSSparams.DEFAULT_TRAILER_FIELD.getValue().equals(trailerField)) {
            throw new IllegalArgumentException("unsupported trailerField " + trailerField);
        }
        switch (contentHashAlgo) {
            case SHA1: {
                this.hashAlgorithm = 544L;
                break;
            }
            case SHA224: {
                this.hashAlgorithm = 597L;
                break;
            }
            case SHA256: {
                this.hashAlgorithm = 592L;
                break;
            }
            case SHA384: {
                this.hashAlgorithm = 608L;
                break;
            }
            case SHA512: {
                this.hashAlgorithm = 624L;
                break;
            }
            case SHA3_224: {
                this.hashAlgorithm = 693L;
                break;
            }
            case SHA3_256: {
                this.hashAlgorithm = 688L;
                break;
            }
            case SHA3_384: {
                this.hashAlgorithm = 704L;
                break;
            }
            case SHA3_512: {
                this.hashAlgorithm = 720L;
                break;
            }
            default: {
                throw new RuntimeException("should not reach here");
            }
        }
        switch (mgfHashAlgo) {
            case SHA1: {
                this.maskGenerationFunction = 1L;
                break;
            }
            case SHA224: {
                this.maskGenerationFunction = 5L;
                break;
            }
            case SHA256: {
                this.maskGenerationFunction = 2L;
                break;
            }
            case SHA384: {
                this.maskGenerationFunction = 3L;
                break;
            }
            case SHA512: {
                this.maskGenerationFunction = 4L;
                break;
            }
            case SHA3_224: {
                this.maskGenerationFunction = 6L;
                break;
            }
            case SHA3_256: {
                this.maskGenerationFunction = 7L;
                break;
            }
            case SHA3_384: {
                this.maskGenerationFunction = 8L;
                break;
            }
            case SHA3_512: {
                this.maskGenerationFunction = 9L;
                break;
            }
            default: {
                throw new RuntimeException("should not reach here");
            }
        }
    }

    public long hashAlgorithm() {
        return this.hashAlgorithm;
    }

    public long maskGenerationFunction() {
        return this.maskGenerationFunction;
    }

    public long saltLength() {
        return this.saltLength;
    }
}

