/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.P11UnknownEntityException;
import org.xipki.security.exception.P11UnsupportedMechanismException;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11NewKeyControl;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11SlotIdentifier;

public interface P11Slot {
    public String moduleName();

    public boolean isReadOnly();

    public P11SlotIdentifier slotId();

    public Set<P11ObjectIdentifier> identityIdentifiers();

    public Set<P11ObjectIdentifier> certIdentifiers();

    public boolean hasIdentity(P11ObjectIdentifier var1);

    public void close();

    public Set<Long> mechanisms();

    public boolean supportsMechanism(long var1);

    public void assertMechanismSupported(long var1) throws P11UnsupportedMechanismException;

    public P11Identity getIdentity(P11ObjectIdentifier var1) throws P11UnknownEntityException;

    public void refresh() throws P11TokenException;

    public P11ObjectIdentifier getObjectIdForId(byte[] var1);

    public P11ObjectIdentifier getObjectIdForLabel(String var1);

    public void updateCertificate(P11ObjectIdentifier var1, X509Certificate var2) throws P11TokenException, CertificateException;

    public int removeObjects(byte[] var1, String var2) throws P11TokenException;

    public void removeIdentity(P11ObjectIdentifier var1) throws P11TokenException;

    public void removeCerts(P11ObjectIdentifier var1) throws P11TokenException;

    public P11ObjectIdentifier addCert(X509Certificate var1) throws P11TokenException, CertificateException;

    public void addCert(P11ObjectIdentifier var1, X509Certificate var2) throws P11TokenException, CertificateException;

    public P11ObjectIdentifier generateRSAKeypair(int var1, BigInteger var2, String var3, P11NewKeyControl var4) throws P11TokenException;

    public P11ObjectIdentifier generateDSAKeypair(int var1, int var2, String var3, P11NewKeyControl var4) throws P11TokenException;

    public P11ObjectIdentifier generateDSAKeypair(BigInteger var1, BigInteger var2, BigInteger var3, String var4, P11NewKeyControl var5) throws P11TokenException;

    public P11ObjectIdentifier generateECKeypair(String var1, String var2, P11NewKeyControl var3) throws P11TokenException;

    public P11ObjectIdentifier generateSecretKey(long var1, int var3, String var4, P11NewKeyControl var5) throws P11TokenException;

    public P11ObjectIdentifier createSecretKey(long var1, byte[] var3, String var4, P11NewKeyControl var5) throws P11TokenException;

    public X509Certificate exportCert(P11ObjectIdentifier var1) throws P11TokenException, CertificateException;

    public void showDetails(OutputStream var1, boolean var2) throws P11TokenException, IOException;
}

