/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.emulator;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.util.IoUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.pkcs11.AbstractP11Module;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.emulator.EmulatorP11Slot;
import org.xipki.security.pkcs11.emulator.PrivateKeyCryptor;

public class EmulatorP11Module
extends AbstractP11Module {
    public static final String PREFIX = "emulator:";
    private static final Logger LOG = LoggerFactory.getLogger(EmulatorP11Module.class);

    private EmulatorP11Module(P11ModuleConf moduleConf) throws P11TokenException {
        super(moduleConf);
        String modulePath = moduleConf.nativeLibrary();
        if (!StringUtil.startsWithIgnoreCase((String)modulePath, (String)PREFIX)) {
            throw new IllegalArgumentException("the module path does not starts with emulator:: " + modulePath);
        }
        File baseDir = new File(IoUtil.expandFilepath((String)modulePath.substring(PREFIX.length())));
        File[] children = baseDir.listFiles();
        if (children == null || children.length == 0) {
            LOG.error("found no slots");
            this.setSlots(Collections.emptySet());
            return;
        }
        HashSet<Integer> allSlotIndexes = new HashSet<Integer>();
        HashSet<Long> allSlotIdentifiers = new HashSet<Long>();
        LinkedList<P11SlotIdentifier> slotIds = new LinkedList<P11SlotIdentifier>();
        for (File child : children) {
            long slotId;
            int slotIndex;
            if (child.isDirectory() && child.canRead() && !child.exists()) {
                LOG.warn("ignore path {}, it does not point to a readable exist directory", (Object)child.getPath());
                continue;
            }
            String filename = child.getName();
            String[] tokens = filename.split("-");
            if (tokens == null || tokens.length != 2) {
                LOG.warn("ignore dir {}, invalid filename syntax", (Object)child.getPath());
                continue;
            }
            try {
                slotIndex = Integer.parseInt(tokens[0]);
                slotId = Long.parseLong(tokens[1]);
            }
            catch (NumberFormatException ex) {
                LOG.warn("ignore dir {}, invalid filename syntax", (Object)child.getPath());
                continue;
            }
            if (allSlotIndexes.contains(slotIndex)) {
                LOG.error("ignore slot dir, the same slot index has been assigned", (Object)filename);
                continue;
            }
            if (allSlotIdentifiers.contains(slotId)) {
                LOG.error("ignore slot dir, the same slot identifier has been assigned", (Object)filename);
                continue;
            }
            allSlotIndexes.add(slotIndex);
            allSlotIdentifiers.add(slotId);
            P11SlotIdentifier slotIdentifier = new P11SlotIdentifier(slotIndex, slotId);
            if (!moduleConf.isSlotIncluded(slotIdentifier)) {
                LOG.info("skipped slot {}", (Object)slotId);
                continue;
            }
            slotIds.add(slotIdentifier);
        }
        HashSet<P11Slot> slots = new HashSet<P11Slot>();
        for (P11SlotIdentifier slotId : slotIds) {
            List<char[]> pwd;
            try {
                pwd = moduleConf.passwordRetriever().getPassword(slotId);
            }
            catch (PasswordResolverException ex) {
                throw new P11TokenException("PasswordResolverException: " + ex.getMessage(), ex);
            }
            File slotDir = new File(baseDir, slotId.index() + "-" + slotId.id());
            if (pwd == null) {
                throw new P11TokenException("no password is configured");
            }
            if (pwd.size() != 1) {
                throw new P11TokenException(pwd.size() + " passwords are configured, but 1 is permitted");
            }
            char[] firstPwd = pwd.get(0);
            PrivateKeyCryptor privateKeyCryptor = new PrivateKeyCryptor(firstPwd);
            int maxSessions = 20;
            EmulatorP11Slot slot = new EmulatorP11Slot(moduleConf.name(), slotDir, slotId, moduleConf.isReadOnly(), firstPwd, privateKeyCryptor, moduleConf.p11MechanismFilter(), maxSessions);
            slots.add(slot);
        }
        this.setSlots(slots);
    }

    public static P11Module getInstance(P11ModuleConf moduleConf) throws P11TokenException {
        ParamUtil.requireNonNull((String)"moduleConf", (Object)moduleConf);
        return new EmulatorP11Module(moduleConf);
    }

    @Override
    public void close() {
        LOG.info("close", (Object)"close pkcs11 module: {}", (Object)this.getName());
    }
}

