/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.provider;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11EntityIdentifier;
import org.xipki.security.pkcs11.P11Params;

public class P11PrivateKey
implements PrivateKey {
    private static final long serialVersionUID = 1L;
    private final P11CryptService p11CryptService;
    private final P11EntityIdentifier identityId;
    private final String algorithm;
    private final int keysize;

    public P11PrivateKey(P11CryptService p11CryptService, P11EntityIdentifier identityId) throws P11TokenException {
        this.p11CryptService = (P11CryptService)ParamUtil.requireNonNull((String)"identityId", (Object)p11CryptService);
        this.identityId = (P11EntityIdentifier)ParamUtil.requireNonNull((String)"entityId", (Object)identityId);
        PublicKey publicKey = p11CryptService.getIdentity(identityId).publicKey();
        if (publicKey instanceof RSAPublicKey) {
            this.algorithm = "RSA";
            this.keysize = ((RSAPublicKey)publicKey).getModulus().bitLength();
        } else if (publicKey instanceof DSAPublicKey) {
            this.algorithm = "DSA";
            this.keysize = ((DSAPublicKey)publicKey).getParams().getP().bitLength();
        } else if (publicKey instanceof ECPublicKey) {
            this.algorithm = "EC";
            this.keysize = ((ECPublicKey)publicKey).getParams().getCurve().getField().getFieldSize();
        } else {
            throw new P11TokenException("unknown public key: " + publicKey);
        }
    }

    boolean supportsMechanism(long mechanism) {
        try {
            return this.p11CryptService.getSlot(this.identityId.slotId()).supportsMechanism(mechanism);
        }
        catch (P11TokenException ex) {
            return false;
        }
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    public int keysize() {
        return this.keysize;
    }

    public byte[] sign(long mechanism, P11Params parameters, byte[] content) throws XiSecurityException, P11TokenException {
        return this.p11CryptService.getIdentity(this.identityId).sign(mechanism, parameters, content);
    }

    P11CryptService p11CryptService() {
        return this.p11CryptService;
    }

    P11EntityIdentifier identityId() {
        return this.identityId;
    }
}

