/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.xipki.common.util.StringUtil;
import org.xipki.security.X509Cert;
import org.xipki.security.exception.BadAsn1ObjectException;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.P11UnknownEntityException;
import org.xipki.security.pkcs11.AbstractP11Slot;
import org.xipki.security.pkcs11.P11EntityIdentifier;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11MechanismFilter;
import org.xipki.security.pkcs11.P11NewKeyControl;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.P11SlotRefreshResult;
import org.xipki.security.pkcs11.proxy.ProxyP11Identity;
import org.xipki.security.pkcs11.proxy.ProxyP11Module;
import org.xipki.security.pkcs11.proxy.msg.Asn1CreateSecretKeyParams;
import org.xipki.security.pkcs11.proxy.msg.Asn1EntityIdAndCert;
import org.xipki.security.pkcs11.proxy.msg.Asn1GenDSAKeypairParams;
import org.xipki.security.pkcs11.proxy.msg.Asn1GenECKeypairParams;
import org.xipki.security.pkcs11.proxy.msg.Asn1GenRSAKeypairParams;
import org.xipki.security.pkcs11.proxy.msg.Asn1GenSecretKeyParams;
import org.xipki.security.pkcs11.proxy.msg.Asn1P11EntityIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1P11ObjectIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1P11ObjectIdentifiers;
import org.xipki.security.pkcs11.proxy.msg.Asn1P11SlotIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1RemoveObjectsParams;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;

public class ProxyP11Slot
extends AbstractP11Slot {
    private final ProxyP11Module module;
    private final P11SlotIdentifier slotId;

    ProxyP11Slot(ProxyP11Module module, P11SlotIdentifier slotId, boolean readOnly, P11MechanismFilter mechanismFilter) throws P11TokenException {
        super(module.getName(), slotId, readOnly, mechanismFilter);
        this.module = module;
        this.slotId = slotId;
        this.refresh();
    }

    @Override
    protected P11SlotRefreshResult refresh0() throws P11TokenException {
        P11SlotRefreshResult refreshResult = new P11SlotRefreshResult();
        List<Long> mechs = this.getMechanismsFromServer();
        for (Long l : mechs) {
            refreshResult.addMechanism(l);
        }
        List<P11ObjectIdentifier> certIds = this.getObjectIdsFromServer((short)261);
        for (P11ObjectIdentifier certId : certIds) {
            X509Cert cert = this.getCertificate(certId);
            if (cert == null) continue;
            refreshResult.addCertificate(certId, cert);
        }
        List<P11ObjectIdentifier> list = this.getObjectIdsFromServer((short)260);
        for (P11ObjectIdentifier keyId : list) {
            ProxyP11Identity identity;
            byte[] id = keyId.id();
            PublicKey pubKey = null;
            X509Cert cert = refreshResult.getCertForId(id);
            pubKey = cert != null ? cert.cert().getPublicKey() : this.getPublicKey(keyId);
            P11EntityIdentifier entityId = new P11EntityIdentifier(this.slotId, keyId);
            if (pubKey == null) {
                identity = new ProxyP11Identity(this, entityId);
            } else {
                X509Certificate[] x509CertificateArray;
                if (cert == null) {
                    x509CertificateArray = null;
                } else {
                    X509Certificate[] x509CertificateArray2 = new X509Certificate[1];
                    x509CertificateArray = x509CertificateArray2;
                    x509CertificateArray2[0] = cert.cert();
                }
                X509Certificate[] certs = x509CertificateArray;
                identity = new ProxyP11Identity(this, entityId, pubKey, certs);
            }
            refreshResult.addIdentity(identity);
        }
        return refreshResult;
    }

    @Override
    public void close() {
    }

    private PublicKey getPublicKey(P11ObjectIdentifier objectId) throws P11UnknownEntityException, P11TokenException {
        P11EntityIdentifier entityId = new P11EntityIdentifier(this.slotId, objectId);
        byte[] resp = this.module.send((short)257, new Asn1P11EntityIdentifier(entityId));
        if (resp == null) {
            return null;
        }
        SubjectPublicKeyInfo pkInfo = SubjectPublicKeyInfo.getInstance((Object)resp);
        try {
            return KeyUtil.generatePublicKey(pkInfo);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new P11TokenException("could not generate Public Key from SubjectPublicKeyInfo:" + ex.getMessage(), ex);
        }
    }

    private X509Cert getCertificate(P11ObjectIdentifier certId) throws P11TokenException {
        P11EntityIdentifier entityId = new P11EntityIdentifier(this.slotId, certId);
        byte[] resp = this.module.send((short)258, new Asn1P11EntityIdentifier(entityId));
        if (resp == null) {
            return null;
        }
        try {
            return new X509Cert(X509Util.parseCert(resp), resp);
        }
        catch (CertificateException ex) {
            throw new P11TokenException("could not parse certificate:" + ex.getMessage(), ex);
        }
    }

    @Override
    public int removeObjects(byte[] id, String label) throws P11TokenException {
        if ((id == null || id.length == 0) && StringUtil.isBlank((String)label)) {
            throw new IllegalArgumentException("at least one of id and label must not be null");
        }
        Asn1RemoveObjectsParams params = new Asn1RemoveObjectsParams(this.slotId, id, label);
        byte[] resp = this.module.send((short)324, params);
        try {
            return ASN1Integer.getInstance((Object)resp).getValue().intValue();
        }
        catch (IllegalArgumentException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
    }

    @Override
    protected void removeIdentity0(P11ObjectIdentifier objectId) throws P11TokenException {
        Asn1P11EntityIdentifier asn1EntityId = new Asn1P11EntityIdentifier(this.slotId, objectId);
        this.module.send((short)321, asn1EntityId);
    }

    @Override
    protected void addCert0(P11ObjectIdentifier objectId, X509Certificate cert) throws P11TokenException, CertificateException {
        Asn1EntityIdAndCert asn1 = new Asn1EntityIdAndCert(new P11EntityIdentifier(this.slotId, objectId), cert);
        this.module.send((short)320, asn1);
    }

    @Override
    protected void removeCerts0(P11ObjectIdentifier objectId) throws P11TokenException {
        Asn1P11EntityIdentifier asn1EntityId = new Asn1P11EntityIdentifier(this.slotId, objectId);
        this.module.send((short)322, asn1EntityId);
    }

    @Override
    protected P11Identity generateSecretKey0(long keyType, int keysize, String label, P11NewKeyControl control) throws P11TokenException {
        Asn1GenSecretKeyParams asn1 = new Asn1GenSecretKeyParams(this.slotId, label, control, keyType, keysize);
        byte[] resp = this.module.send((short)309, asn1);
        return this.parseGenerateSecretKeyResult(resp);
    }

    @Override
    protected P11Identity createSecretKey0(long keyType, byte[] keyValue, String label, P11NewKeyControl control) throws P11TokenException {
        Asn1CreateSecretKeyParams asn1 = new Asn1CreateSecretKeyParams(this.slotId, label, control, keyType, keyValue);
        byte[] resp = this.module.send((short)310, asn1);
        return this.parseGenerateSecretKeyResult(resp);
    }

    @Override
    protected P11Identity generateRSAKeypair0(int keysize, BigInteger publicExponent, String label, P11NewKeyControl control) throws P11TokenException {
        Asn1GenRSAKeypairParams asn1 = new Asn1GenRSAKeypairParams(this.slotId, label, control, keysize, publicExponent);
        byte[] resp = this.module.send((short)304, asn1);
        return this.parseGenerateKeypairResult(resp);
    }

    @Override
    protected P11Identity generateDSAKeypair0(BigInteger p, BigInteger q, BigInteger g, String label, P11NewKeyControl control) throws P11TokenException {
        Asn1GenDSAKeypairParams asn1 = new Asn1GenDSAKeypairParams(this.slotId, label, control, p, q, g);
        byte[] resp = this.module.send((short)305, asn1);
        return this.parseGenerateKeypairResult(resp);
    }

    @Override
    protected P11Identity generateECKeypair0(ASN1ObjectIdentifier curveId, String label, P11NewKeyControl control) throws P11TokenException {
        Asn1GenECKeypairParams asn1 = new Asn1GenECKeypairParams(this.slotId, label, control, curveId);
        byte[] resp = this.module.send((short)307, asn1);
        return this.parseGenerateKeypairResult(resp);
    }

    private P11Identity parseGenerateKeypairResult(byte[] resp) throws P11TokenException {
        Asn1P11EntityIdentifier ei;
        if (resp == null) {
            throw new P11TokenException("server returned no result");
        }
        try {
            ei = Asn1P11EntityIdentifier.getInstance(resp);
        }
        catch (BadAsn1ObjectException ex) {
            throw new P11TokenException("invalid ASN1 object Asn1P11EntityIdentifier: " + ex.getMessage(), ex);
        }
        if (!this.slotId.equals(ei.slotId().slotId())) {
            throw new P11TokenException("");
        }
        P11EntityIdentifier entityId = ei.entityId();
        PublicKey publicKey = this.getPublicKey(entityId.objectId());
        return new ProxyP11Identity(this, entityId, publicKey, null);
    }

    private P11Identity parseGenerateSecretKeyResult(byte[] resp) throws P11TokenException {
        Asn1P11EntityIdentifier ei;
        if (resp == null) {
            throw new P11TokenException("server returned no result");
        }
        try {
            ei = Asn1P11EntityIdentifier.getInstance(resp);
        }
        catch (BadAsn1ObjectException ex) {
            throw new P11TokenException("invalid ASN1 object Asn1P11EntityIdentifier: " + ex.getMessage(), ex);
        }
        if (!this.slotId.equals(ei.slotId().slotId())) {
            throw new P11TokenException("");
        }
        P11EntityIdentifier entityId = ei.entityId();
        return new ProxyP11Identity(this, entityId);
    }

    @Override
    protected void updateCertificate0(P11ObjectIdentifier objectId, X509Certificate newCert) throws P11TokenException, CertificateException {
        Asn1EntityIdAndCert asn1 = new Asn1EntityIdAndCert(new P11EntityIdentifier(this.slotId, objectId), newCert);
        this.module.send((short)323, asn1);
    }

    private List<Long> getMechanismsFromServer() throws P11TokenException {
        Asn1P11SlotIdentifier asn1SlotId = new Asn1P11SlotIdentifier(this.slotId);
        byte[] resp = this.module.send((short)262, asn1SlotId);
        ASN1Sequence seq = this.requireSequence(resp);
        int n = seq.size();
        ArrayList<Long> mechs = new ArrayList<Long>(n);
        for (int i = 0; i < n; ++i) {
            long mech = ASN1Integer.getInstance((Object)seq.getObjectAt(i)).getValue().longValue();
            mechs.add(mech);
        }
        return mechs;
    }

    private List<P11ObjectIdentifier> getObjectIdsFromServer(short action) throws P11TokenException {
        List<Asn1P11ObjectIdentifier> asn1ObjectIds;
        Asn1P11SlotIdentifier asn1SlotId = new Asn1P11SlotIdentifier(this.slotId);
        byte[] resp = this.module.send(action, asn1SlotId);
        try {
            asn1ObjectIds = Asn1P11ObjectIdentifiers.getInstance(resp).objectIds();
        }
        catch (BadAsn1ObjectException ex) {
            throw new P11TokenException("bad ASN1 object: " + ex.getMessage(), ex);
        }
        ArrayList<P11ObjectIdentifier> objectIds = new ArrayList<P11ObjectIdentifier>(asn1ObjectIds.size());
        for (Asn1P11ObjectIdentifier asn1Id : asn1ObjectIds) {
            objectIds.add(asn1Id.objectId());
        }
        return objectIds;
    }

    private ASN1Sequence requireSequence(byte[] response) throws P11TokenException {
        try {
            return ASN1Sequence.getInstance((Object)response);
        }
        catch (IllegalArgumentException ex) {
            throw new P11TokenException("response is not ASN1Sequence", ex);
        }
    }

    ProxyP11Module module() {
        return this.module;
    }
}

