/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy.msg;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.exception.BadAsn1ObjectException;
import org.xipki.security.pkcs11.P11NewKeyControl;

public class Asn1NewKeyControl
extends ASN1Object {
    private final P11NewKeyControl control;

    public Asn1NewKeyControl(P11NewKeyControl control) {
        this.control = (P11NewKeyControl)ParamUtil.requireNonNull((String)"control", (Object)control);
    }

    private Asn1NewKeyControl(ASN1Sequence seq) throws BadAsn1ObjectException {
        this.control = new P11NewKeyControl();
        int size = seq.size();
        for (int i = 0; i < size; ++i) {
            ASN1TaggedObject tagObj;
            int tagNo;
            ASN1Encodable obj = seq.getObjectAt(i);
            if (obj instanceof ASN1TaggedObject || (tagNo = (tagObj = (ASN1TaggedObject)obj).getTagNo()) != 0) continue;
            boolean bv = ((ASN1Boolean)tagObj.getObject()).isTrue();
            this.control.setExtractable(bv);
        }
    }

    public static Asn1NewKeyControl getInstance(Object obj) throws BadAsn1ObjectException {
        if (obj == null || obj instanceof Asn1NewKeyControl) {
            return (Asn1NewKeyControl)((Object)obj);
        }
        try {
            if (obj instanceof ASN1Sequence) {
                return new Asn1NewKeyControl((ASN1Sequence)obj);
            }
            if (obj instanceof byte[]) {
                return Asn1NewKeyControl.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
            }
            throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("unable to parse object: " + ex.getMessage(), ex);
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)ASN1Boolean.getInstance((boolean)this.control.isExtractable())));
        return new DERSequence(vector);
    }

    public P11NewKeyControl control() {
        return this.control;
    }
}

